<?php
/**
 * Theme functions and definitions
 *
 * @package HelloElementorChild
 */

/**
 * Load child theme css and optional scripts
 *
 * @return void
 */
function hello_elementor_child_enqueue_scripts() {
	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		'1.0.0'
	);
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_enqueue_scripts' );

/* پاپ آپ برو به سبد خرید*/
 
add_action('wp_ajax_tamadon_add_to_cart', 'tamadon_add_to_cart_callback');
add_action('wp_ajax_nopriv_tamadon_add_to_cart', 'tamadon_add_to_cart_callback');
function tamadon_add_to_cart_callback() {
    if (!isset($_POST['product_id']) || !is_numeric($_POST['product_id'])) {
        wp_send_json_error(['message' => 'شناسه محصول نامعتبر']);
    }
    $product_id = intval($_POST['product_id']);
    $quantity = isset($_POST['quantity']) ? intval($_POST['quantity']) : 1;
    $variation_id = isset($_POST['variation_id']) ? intval($_POST['variation_id']) : 0;
    $variation = [];
    if ($variation_id) {
        foreach ($_POST as $key => $value) {
            if (strpos($key, 'attribute_') === 0) {
                $variation[$key] = sanitize_text_field($value);
            }
        }
    }
    $product = wc_get_product($product_id);
    if (!$product) {
        wp_send_json_error(['message' => 'محصول یافت نشد']);
    }
    $cart_item_key = WC()->cart->add_to_cart($product_id, $quantity, $variation_id, $variation);
    if ($cart_item_key) {
        $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'thumbnail');
        $image_url = $image ? $image[0] : wc_placeholder_img_src();
        $price = $variation_id ? wc_get_product($variation_id)->get_price_html() : $product->get_price_html();
        wp_send_json_success([
            'image' => $image_url,
            'title' => $product->get_name(),
            'price' => $price,
            'cart_count' => WC()->cart->get_cart_contents_count()
        ]);
    } else {
        wp_send_json_error(['message' => 'خطا در افزودن به سبد خرید']);
    }
}



function tamadon_add_cart_popup() {
    if (!is_product()) {
        return;
    }
    ?>
    <div id="tamadonCartPopup" class="tamadon-cart-popup" style="display: none;">
        <div class="tamadon-cart-popup-content">
            <button class="tamadon-cart-popup-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 15L1 1" stroke="#3C3D45" stroke-width="1.5" stroke-linecap="round"></path>
                    <path d="M1 15L15 1" stroke="#3C3D45" stroke-width="1.5" stroke-linecap="round"></path>
                </svg>
            </button>
            <h2 class="tamadon-cart-popup-title">این کالا به سبد خرید اضافه شد</h2>
            <hr class="tamadon-cart-popup-divider">
            <div class="tamadon-cart-popup-product">
                <img id="tamadonPopupProductImage" src="" alt="محصول" class="tamadon-cart-popup-image">
                <div class="tamadon-cart-popup-details">
                    <h3 id="tamadonPopupProductTitle" class="tamadon-cart-popup-product-title"></h3>
                    <p id="tamadonPopupProductPrice" class="tamadon-cart-popup-product-price"></p>
                </div>
            </div>
            <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="tamadon-cart-popup-button">برو به سبد خرید</a>
        </div>
    </div>

    <script>
    jQuery(document).ready(function($) {
        $(document).on('click', '.single_add_to_cart_button', function(e) {
            e.preventDefault();
            var $thisbutton = $(this),
                $form = $thisbutton.closest('form.cart'),
                product_id = $form.find('input[name="product_id"]').val() || $thisbutton.val(),
                quantity = $form.find('input[name="quantity"]').val() || 1,
                variation_id = $form.find('input[name="variation_id"]').val() || 0;
            var data = {
                action: 'tamadon_add_to_cart',
                product_id: product_id,
                quantity: quantity,
                variation_id: variation_id
            };
            if (variation_id) {
                $form.find('select[name^="attribute_"]').each(function() {
                    data[$(this).attr('name')] = $(this).val();
                });
            }
            $thisbutton.addClass('disabled loading');
            $.ajax({
                type: 'POST',
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                data: data,
                success: function(response) {
                    if (response.success) {
                        $('#tamadonPopupProductImage').attr('src', response.data.image);
                        $('#tamadonPopupProductTitle').text(response.data.title);
                        $('#tamadonPopupProductPrice').html(response.data.price);
                        $('#tamadonCartPopup').fadeIn(300);
                        $('.cart-items-count').text(response.data.cart_count);
                    } else {
                        alert('خطا در افزودن محصول به سبد خرید: ' + (response.data.message || 'مشکل ناشناخته'));
                    }
                },
                error: function() {
                    alert('خطا در ارتباط با سرور. لطفاً دوباره امتحان کنید.');
                },
                complete: function() {
                    $thisbutton.removeClass('disabled loading');
                }
            });
        });
        $(document).on('click', '.tamadon-cart-popup', function(e) {
            if ($(e.target).hasClass('tamadon-cart-popup')) {
                $('#tamadonCartPopup').fadeOut(300);
            }
        });
        $('.tamadon-cart-popup-content').on('click', function(e) {
            e.stopPropagation();
        });
        $('.tamadon-cart-popup-close').on('click', function() {
            $('#tamadonCartPopup').fadeOut(300);
        });
    });
    </script>

    <style>
        .tamadon-cart-popup {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
        .tamadon-cart-popup-content {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            max-width: 400px;
            width: 90%;
            position: relative;
            animation: tamadon-popupFadeIn 0.3s ease;
        }
        .tamadon-cart-popup-close {
            position: absolute;
			top: 16px;
    		left: 16px;
            background: none;
            border: none;
            cursor: pointer;
            padding: 5px;
			background: transparent !important
        }
		.tamadon-cart-popup-close:hover,
		.tamadon-cart-popup-close:active,
		.tamadon-cart-popup-close:focus{
			background: transparent !important
		}
        .tamadon-cart-popup-close svg {
            display: block;
        }
        .tamadon-cart-popup-title {
            font-size: 16px;
            margin: 0 0 15px;
            text-align: right;
        }
        .tamadon-cart-popup-divider {
            border: 0;
            border-top: 1px solid #eee;
            margin: 15px 0;
        }
        .tamadon-cart-popup-product {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .tamadon-cart-popup-image {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 4px;
        }
        .tamadon-cart-popup-details {
            flex: 1;
        }
        .tamadon-cart-popup-product-title {
            font-size: 14px;
            margin: 0 0 10px;
            color: #666;
            font-weight: 400;
        }
        .tamadon-cart-popup-product-price {
            font-size: 14px;
            color: #333;
            text-decoration: none;
        }
        .tamadon-cart-popup-product-price del {
            font-size: 13px;
            color: #888;
        }
        .tamadon-cart-popup-product-price ins {
            text-decoration: none;
        }
        .tamadon-cart-popup-button {
            display: block;
            text-align: center;
            background: var(--e-global-color-secondary);
            color: #fff !important;
            padding: 10.5px 24px;
            font-size: 14px;
            line-height: 1.5;
            border-radius: 4px;
            transition: all 0.2s;
            min-width: 100px;
            position: relative;
            margin-top: 16px;
            text-decoration: none;
        }
        @keyframes tamadon-popupFadeIn {
            from { opacity: 0; transform: scale(0.8); }
            to { opacity: 1; transform: scale(1); }
        }
        @media (max-width: 480px) {
            .tamadon-cart-popup-content {
                width: 95%;
                padding: 15px;
            }
            .tamadon-cart-popup-image {
                width: 60px;
                height: 60px;
            }
        }
    </style>
    <?php
}
add_action('wp_footer', 'tamadon_add_cart_popup');

// اضافه کردن پاپ‌آپ تأیید برای حذف محصول در سبد خرید
add_action('wp_footer', 'tamadon_cart_remove_confirmation_popup');
function tamadon_cart_remove_confirmation_popup() {
    if (!is_cart()) {
        return;
    }
    ?>
    <div id="tamadon-cart-remove-modal" class="tamadon-modal" style="display: none;">
        <div class="tamadon-modal-content">
            <h4>حذف کالا</h4>
            <p>آیا مطمئن هستید که می‌خواهید این کالا را از سبد خرید حذف کنید؟</p>
            <div class="tamadon-modal-buttons">
                <button id="tamadon-confirm-remove" class="button">بله، حذف کن</button>
                <button id="tamadon-cancel-remove" class="button">خیر</button>
            </div>
        </div>
    </div>

    <style>
        .tamadon-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgb(0 0 0 / 11%);
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .tamadon-modal-content {
            background: #fff;
            padding: 20px;
            border-radius: 24px;
            text-align: center;
            max-width: 400px;
            width: 90%;
            box-shadow: 0 2px 20px rgb(0 0 0 / 7%);
        }
        .tamadon-modal-content h4 {
            font-weight: 600;
            margin: 8px;
            font-size: 20px;
        }
        .tamadon-modal-content p {
            margin: 0 0 20px;
            color: #888;
            font-size: 14px;
            border-bottom: 1px solid rgba(32, 34, 38, 0.08);
            padding-bottom: 16px;
        }
        .tamadon-modal-buttons {
            display: flex;
            justify-content: center;
            gap: 10px;
        }
        .tamadon-modal-buttons .button {
            padding: 12.5px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            position: relative;
        }
        #tamadon-confirm-remove {
            background: var(--e-global-color-secondary);
            color: #fff;
        }
        #tamadon-cancel-remove {
            background: #EEEEEE;
            color: #333;
        }
        .tamadon-loading::after {
            content: '';
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid #fff;
            border-radius: 50%;
            border-top-color: transparent;
            animation: spin 1s linear infinite;
            margin-right: 5px;
            vertical-align: middle;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        @media (max-width: 480px) {
            .tamadon-modal-content {
                padding: 15px;
                max-width: 300px;
            }
            .tamadon-modal-content p {
                font-size: 14px;
            }
            .tamadon-modal-buttons .button {
                padding: 8px 15px;
                font-size: 12px;
            }
        }
    </style>

    <script>
    jQuery(document).ready(function($) {
        $(document).on('click', '.cart_item .remove', function(e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            const $removeLink = $(this);
            const removeUrl = $removeLink.attr('href');
            const $cartItem = $removeLink.closest('.cart_item');
            const modal = $('#tamadon-cart-remove-modal');
            modal.fadeIn(300);
            $('#tamadon-confirm-remove').off('click').on('click', function() {
                const $button = $(this);
                $button.addClass('tamadon-loading').prop('disabled', true).text('در حال حذف...');
                $.ajax({
                    url: removeUrl,
                    type: 'GET',
                    dataType: 'html',
                    success: function(response) {
                        $cartItem.fadeOut(300, function() {
                            $(this).remove();
                            if ($('.cart_item').length === 0) {
                                $('.woocommerce-cart-form').html('<p class="cart-empty woocommerce-info">سبد خرید شما خالی است.</p>');
                            }
                        });
                        $.ajax({
                            url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_refreshed_fragments'),
                            type: 'POST',
                            data: {
                                time: new Date().getTime()
                            },
                            success: function(data) {
                                if (data && data.fragments) {
                                    $.each(data.fragments, function(key, value) {
                                        const $element = $(key);
                                        if ($element.length) {
                                            $element.replaceWith(value);
                                        }
                                    });
                                    $.ajax({
                                        url: wc_cart_fragments_params.wc_ajax_url.toString().replace('%%endpoint%%', 'get_cart_totals'),
                                        type: 'POST',
                                        success: function(totals_html) {
                                            const $cartTotals = $('.cart_totals');
                                            if ($cartTotals.length) {
                                                $cartTotals.replaceWith(totals_html);
                                            }
                                        }
                                    });
                                    if (data.cart_count !== undefined) {
                                        $('.cart-contents .count').text(data.cart_count);
                                    }
                                    $(document.body).trigger('wc_fragments_refreshed');
                                    $(document.body).trigger('wc_cart_totals_refreshed');
                                }
                                $button.removeClass('tamadon-loading').prop('disabled', false).text('بله، حذف کن');
                                modal.fadeOut(300);
                            },
                            error: function() {
                                window.location.href = removeUrl;
                                $button.removeClass('tamadon-loading').prop('disabled', false).text('بله، حذف کن');
                            }
                        });
                    },
                    error: function() {
                        window.location.href = removeUrl;
                        $button.removeClass('tamadon-loading').prop('disabled', false).text('بله، حذف کن');
                    }
                });
            });
            $('#tamadon-cancel-remove').off('click').on('click', function() {
                modal.fadeOut(300);
            });
            modal.on('click', function(e) {
                if ($(e.target).hasClass('tamadon-modal')) {
                    modal.fadeOut(300);
                }
            });
        });
    });
    </script>
    <?php
}
//انتقال محصولات نا موجود به انتهای لیست
add_filter( 'woocommerce_get_catalog_ordering_args', 'mihanwp_sort_by_stock', 9999 );
 
function mihanwp_sort_by_stock( $args ) {
   $args['orderby'] = 'meta_value';
   $args['order'] = 'ASC';
   $args['meta_key'] = '_stock_status';
   return $args;
}


//خلاصه دیدگاه

function fb_generate_ai_review_summary($product_id) {

    $comments = get_comments([
        'post_id' => $product_id,
        'status'  => 'approve',
        'type'    => 'review',
        'number'  => 30,
        'orderby' => 'comment_date',
        'order'   => 'DESC'
    ]);

    if (empty($comments)) {
        update_post_meta($product_id, '_ai_review_summary', "دیدگاهی ثبت نشده است");
        return;
    }

    $all_comments_text = '';
    foreach ($comments as $comment) {
        $all_comments_text .= $comment->comment_content . "\n";
    }

    $all_comments_text = substr($all_comments_text, 0, 6000);

    // کلید API خود را در خط پایین قرار دهید
    $api_key = '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';

    $body = [
        // model هوش مصنوعی خود را اینجا قرار دهید
        'model' => 'tngtech/deepseek-r1t2-chimera:free',
        'messages' => [
            [
                'role' => 'user',
                'content' => "Summarize the following customer reviews in Persian for new users in about 75 to 100 words. Focus on both positive and negative aspects, but do not use headings like pros or cons. Write the summary in a neutral, helpful tone, in a single paragraph. Do not use special characters such as # @  _ - , . . .:\n\n" . $all_comments_text
            ]
        ]
    ];

    $response = wp_remote_post('https://openrouter.ai/api/v1/chat/completions', [
        'headers' => [
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $api_key,
        ],
        'body' => wp_json_encode($body),
        'timeout' => 60,
    ]);

    if (is_wp_error($response)) {
        error_log("AI Summary request error: " . $response->get_error_message());
        return;
    }

    $data = json_decode(wp_remote_retrieve_body($response), true);
	error_log(print_r($data, true));
	if (!empty($data['choices'][0]['message']['content'])) {
		$summary = $data['choices'][0]['message']['content'];
		update_post_meta($product_id, '_ai_review_summary', $summary);
	} else {
		error_log("پاسخ AI empty و یا invalid بود");
	}
}

function fb_schedule_or_run_summary($comment_post_ID) {
    if (get_post_type($comment_post_ID) !== 'product') {
        return;
    }
    wp_clear_scheduled_hook('fb_generate_ai_review_summary_cron', [$comment_post_ID]);
    wp_schedule_single_event(time() + 30, 'fb_generate_ai_review_summary_cron', [$comment_post_ID]);
}

// اجرای کد به صورت async بعد از گذاشتن کامنت
add_action('wp_insert_comment', function($comment_ID, $comment) {
    if ($comment->comment_approved == 1) {
        fb_schedule_or_run_summary($comment->comment_post_ID);
    }
}, 10, 2);

add_action('wp_set_comment_status', function($comment_ID, $status) {
    if ($status === 'approve') {
        $comment = get_comment($comment_ID);
        if ($comment) {
            fb_schedule_or_run_summary($comment->comment_post_ID);
        }
    }
}, 10, 2);

add_action('fb_generate_ai_review_summary_cron', 'fb_generate_ai_review_summary');

add_shortcode('ai_review_summary', function() {
    $product_id = get_the_ID();
    $summary = get_post_meta($product_id, '_ai_review_summary', true);
    return $summary ? wpautop($summary) : "دیدگاهی برای این محصول ثبت نشده است.";
});

//نقشه برای سبد حرید


// 1. اضافه کردن کدهای Leaflet js
add_action('wp_enqueue_scripts', function() {
    if(is_checkout()) {
        wp_enqueue_style('leaflet-css', 'https://unpkg.com/leaflet/dist/leaflet.css');
        wp_enqueue_script('leaflet-js', 'https://unpkg.com/leaflet/dist/leaflet.js', [], null, true);
        wp_add_inline_script('leaflet-js', "
            document.addEventListener('DOMContentLoaded', function(){
                const map = L.map('fb-map').setView([35.6892, 51.3890], 13);
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);

                let marker;
                map.on('click', function(e){
                    if(marker) map.removeLayer(marker);
                    marker = L.marker(e.latlng).addTo(map);
                    document.querySelector('#checkout_latlng').value = e.latlng.lat + ',' + e.latlng.lng;
                });
            });
        ");
    }
});


// 2. اضافه کردن فیلد مپ و input
add_action('woocommerce_after_order_notes', function($checkout){
    echo '<div class="fb-map-message">میتوانید برای ارسال مطمئن تر لوکیشن خود را ثبت کنید</div>';
    echo '<div id="fb-map" style="height:300px;"></div>';
    echo '<input type="hidden" id="checkout_latlng" name="checkout_latlng">';
});


// 3. ذخیره اطلاعات مپ
add_action('woocommerce_checkout_create_order', function($order, $data){
    if(!empty($_POST['checkout_latlng'])){
        $order->update_meta_data('_delivery_location', sanitize_text_field($_POST['checkout_latlng']));
    }
}, 20, 2);


// 4. نمایش در پنل سفارشات ادمین
add_action('woocommerce_admin_order_data_after_billing_address', function($order){
    $location = $order->get_meta('_delivery_location');
    if($location){
        $maps_url = 'https://www.google.com/maps?q=' . $location;
        echo '<p><strong>لوکیشن ارسال: </strong><br><a href="'.$maps_url.'" target="_blank">برای دیدن لوکشن ارسال کلیک کنید</a></p>';

        //qr کد برای اسکن نقشه
        echo '<img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data='.urlencode($maps_url).'" alt="QR Code" />';
    }
});


// // 5. اجباری کردن ارسال لوکیشن
// add_action('woocommerce_checkout_process', function() {
//     if(empty($_POST['checkout_latlng'])){
//         wc_add_notice('لطفا موقعیت خود را روی نقشه انتخاب کنید.', 'error');
//     }
// });
// توجـــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــــه 
// کد های زیر مربوط به قیمت محصول هست
// کدهای ذخیره  کردن درصد تخفیف و کمترین قیمت در دیتابیس 
function fb_update_discount_meta($product_id) {
    $product = wc_get_product($product_id);

    if (!$product) {
        return;
    }

    if ($product->is_type("variable")) {
        $variations_ids = $product->get_children();
        $max_discount = 0;

        foreach($variations_ids as $variation_id) {
            $variation_product = wc_get_product($variation_id);
            if ($variation_product && $variation_product->is_in_stock()) {
                $regular_price = floatval($variation_product->get_regular_price());
                $sale_price = floatval($variation_product->get_sale_price());

                if ($sale_price && $regular_price > $sale_price) {
                    $discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
                }

                if ($discount_percentage > $max_discount) {
                    $max_discount = $discount_percentage;
                }
            }
        }
        if ($max_discount > 0) {
            update_post_meta($product_id, "discount_percentage", $max_discount);
        } else {
            delete_post_meta($product_id, "discount_percentage");
        }
    } else {
        $discount_percentage = 0;
        
        if ($product->is_in_stock()) {
                $regular_price = floatval($product->get_regular_price());
                $sale_price = floatval($product->get_sale_price());

                if ($sale_price && $regular_price > $sale_price) {
                    $discount_percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
                }
        }
        if ($discount_percentage > 0) {
            update_post_meta($product_id, "discount_percentage",  $discount_percentage);
        } else {
            delete_post_meta($product_id, "discount_percentage");
        }
    }
}

function fb_min_price_of_variation($product_id) {
    $product = wc_get_product($product_id);

    if (!$product || !$product->is_type("variable")) {
        return;
    }

    $min_price = null;
    $variations_ids = $product->get_children();

    foreach($variations_ids as $variation_id) {
        $variation_product = wc_get_product($variation_id);
        if ($variation_product && $variation_product->is_in_stock()) {
            $price = floatval($variation_product->get_price());
            
            if (is_null($min_price) || $price < $min_price) {
                $min_price = $price;
            }
        }
    }
    update_post_meta($product_id, "min_variation_price", $min_price);
}

add_action("woocommerce_update_product", "fb_update_discount_meta");
add_action("woocommerce_update_product", "fb_min_price_of_variation");
// کد تغییر تومان به متن یا المان دلخواه که باید در functions.php گذاشته شود

add_filter( 'woocommerce_currency_symbol', function( $currency_symbol, $currency ) {
    if ( $currency !== 'IRT' ) {
        return $currency_symbol;
    }

    if ( is_admin() ) {
        return 'تومان';
    }

   $currency_symbol = '<svg width="13" height="12" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2.32 6.118c.315-.154.552-.308.789-.539l.473-.692c.079-.308.158-.616.158-.924h7.492c.473 0 .867-.154 1.183-.385.236-.308.394-.692.394-1.231V.5h-1.025v1.77c0 .385-.237.616-.631.616H3.74V2.5c0-.385-.08-.616-.158-.924 0-.23-.158-.461-.316-.615a1.654 1.654 0 0 0-.473-.308C2.557.577 2.32.5 2.163.5c-.316 0-.553.077-.79.154C1.217.808.98.884.9 1.116c-.157.154-.315.307-.315.538-.079.231-.158.462-.158.693 0 .23 0 .462.08.693.078.23.157.384.236.538.157.077.315.231.552.308.236.077.473.077.867.077h.631c0 .154-.079.308-.079.462-.079.154-.236.308-.315.462-.079.076-.237.153-.473.23a1.515 1.515 0 0 1-.631.154H.27V6.35h1.025c.394-.077.71-.154 1.025-.231zm-.158-3.232c-.315 0-.473 0-.63-.154-.08-.077-.158-.231-.158-.462 0-.23.079-.462.157-.539.158-.077.316-.154.552-.154.237 0 .395.077.552.231.158.154.158.385.158.693v.462h-.63v-.077z" fill="#021959"/><path d="M10.442.5H7.445v.923h2.997V.5zM12.73 8.504c-.08-.231-.158-.385-.316-.539-.157-.154-.315-.308-.552-.385a1.515 1.515 0 0 0-.63-.154c-.237 0-.474.077-.71.154-.237.077-.395.231-.552.385-.158.154-.237.308-.316.539-.079.23-.079.462-.079.692v.231c0 .231-.079.308-.158.462-.157.077-.315.154-.552.154H8.55a.61.61 0 0 1-.394-.154c-.08-.154-.158-.308-.158-.462V5.733H6.973v3.848c0 .308 0 .539.079.693.078.154.157.308.315.462.158.076.237.23.473.23.158.077.316.077.552.077h.552c.158 0 .395-.077.552-.153.158-.078.395-.231.474-.462.157.23.315.384.552.461.236.077.473.154.788.154.473 0 .947-.153 1.183-.461.316-.308.473-.77.473-1.309a9.513 9.513 0 0 0-.236-.77zM11.23 9.966c-.236 0-.394-.077-.473-.154-.236-.154-.236-.308-.236-.539 0-.23.078-.384.157-.538.08-.154.316-.231.552-.231.237 0 .474.077.552.23.08.155.158.309.158.54-.079.461-.315.692-.71.692zM4.923 8.504c0 .23 0 .384-.08.615l-.236.462c-.158.154-.315.23-.473.308a1.607 1.607 0 0 1-.71.154h-.71c-.236 0-.473 0-.71-.077-.157-.154-.315-.231-.394-.385-.079-.154-.236-.308-.236-.462-.08-.154-.08-.384-.08-.615v-.847H.27v.924c0 .77.236 1.385.63 1.847.395.461.947.692 1.735.692h.79c.393 0 .709-.077 1.024-.23.316-.155.552-.309.789-.54.237-.23.394-.538.473-.846.08-.308.158-.616.158-1v-2.77l-1.025-.078.079 2.848z" fill="#021959"/><path d="M3.74 7.426H2.557v1.077H3.74V7.426z" fill="#021959"/></svg>';
   
    return $currency_symbol;
}, 10, 2 );
// تغییر ساختار قیمت
add_filter("woocommerce_get_price_html", function($price_html, $product) {
    if (!$product) {
        return $price_html;
    }

    if ($product->is_on_sale()) {
        if ($product->is_type("variable")) {
            // برای محصولات متغیر: فقط شروع قیمت از کمترین قیمت وارییشن
            $main_price = get_post_meta($product->get_id(), "min_variation_price", true);
            $custom_html = '<span class="fb-product-price-wrapper">
                <span class="fb-product-start-text">شروع قیمت از:<br>&nbsp;</span>
                <span class="fb-product-main-price">'. wc_price($main_price) .'</span>
            </span>';
        } else {
            // برای محصولات ساده با تخفیف: قیمت قبلی در خط اول، قیمت تخفیف در خط دوم
            $regular_price = floatval($product->get_regular_price());
            $main_price = floatval($product->get_sale_price());
            $custom_html = '<span class="fb-product-price-wrapper fb-on-sale">
                <span class="fb-product-regular-price">'. wc_price($regular_price) .'</span><br>
                <span class="fb-product-main-price">'. wc_price($main_price) .'</span>
            </span>';
        }
    } else {
        if ($product->is_type("variable")) {
            $main_price = get_post_meta($product->get_id(), "min_variation_price", true);
            $custom_html = '<span class="fb-product-price-wrapper">
                <span class="fb-product-start-text">شروع قیمت از: <br>&nbsp;</span>
                <span class="fb-product-main-price">'. wc_price($main_price) .'</span>
            </span>';
        } else {
            $main_price = floatval($product->get_regular_price());
            $custom_html = '<span class="fb-product-price-wrapper">
                <span class="fb-product-main-price">'. wc_price($main_price) .'</span>
            </span>';
        }
    }
    return $custom_html;
}, 10, 2);

add_filter("woocommerce_available_variation", function($variation_data) {
    $variation = wc_get_product($variation_data["variation_id"]);

    if ($variation->is_on_sale()) {
        // برای وارییشن با تخفیف: قیمت قبلی در خط اول، قیمت تخفیف در خط دوم
        $regular_price = floatval($variation->get_regular_price());
        $sale_price = floatval($variation->get_sale_price());
        $variation_data["price_html"] = '<span class="fb-product-price-wrapper fb-on-sale">
                <span class="fb-product-regular-price">'. wc_price($regular_price) .'</span><br>
                <span class="fb-product-main-price">'. wc_price($sale_price) .'</span>
            </span>';
    } else {
        $regular_price = floatval($variation->get_regular_price());
        $variation_data["price_html"] = '<span class="fb-product-price-wrapper">
                <span class="fb-product-main-price">'. wc_price($regular_price) .'</span>
            </span>';
    }
    return $variation_data;
});