<?php
// phpcs:disable
?>
<div
	class="jet-ajax-search-settings-page jet-ajax-search-settings-page__settings"
>
<div class="jet-ajax-search-request-settings">
	<div class="cx-vui-subtitle"><?php _e( 'Search Request Settings', 'jet-search' ); ?></div>

	<cx-vui-radio
		name="ajax-request-types"
		:wrapper-css="[ 'equalwidth' ]"
		label="<?php _e( 'Request Type', 'jet-search' ); ?>"
		v-model="requestSettings.request_type"
		:optionsList="requestTypeList"
	>
	</cx-vui-radio>
</div>

<div class="jet-ajax-search-query-settings" v-if="isDataLoaded">

	<div class="cx-vui-subtitle"><?php _e( 'Ajax Search Widgets Default Query Settings', 'jet-search' ); ?></div>

		<cx-vui-component-wrapper
			:wrapper-css="[ 'jet-search-settings' ]"
		>
			<div class="cx-vui-component__label">Please note!</div>
			<div class="cx-vui-component__desc">Settings set here will be used as defaults for any search widget you use on your website. By setting these defaults, you can shorten the search results URL generated by any widget.</div>
		</cx-vui-component-wrapper>

		<cx-vui-switcher
			name="show_search_category_list"
			label="<?php _e( 'Show Categories List', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			return-true="true"
			return-false="false"
			v-model="querySettings['show_search_category_list']">
		</cx-vui-switcher>

		<cx-vui-select
			name="search_taxonomy"
			label="<?php _e( 'Taxonomy', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			:options-list="taxonomiesList"
			size="fullwidth"
			v-model="querySettings['search_taxonomy']"
			:conditions="[
				{
					input: this.querySettings['show_search_category_list'],
					compare: 'equal',
					value: 'true',
				},
			]">
		</cx-vui-select>

		<cx-vui-switcher
			name="current-query"
			label="<?php _e( 'Search by the current query', 'jet-search' ); ?>"
			description="<?php _e( 'Use for Archive Templates', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			return-true="true"
			return-false="false"
			v-model="querySettings['current_query']">
		</cx-vui-switcher>

		<cx-vui-f-select
			name="search-source"
			label="<?php _e( 'Source', 'jet-search' ); ?>"
			description="<?php _e( 'You can select particular search areas. If nothing is selected in the option, the search will be made over the entire site.', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			multiple="true"
			size="fullwidth"
			:options-list="searchSourceList"
			v-model="querySettings['search_source']"
			:conditions="[
				{
					input: this.querySettings['current_query'],
					compare: 'equal',
					value: 'false',
				},
			]">
		</cx-vui-f-select>

		<cx-vui-f-select
			name="include_terms_ids"
			label="<?php _e( 'Include Terms', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			multiple="true"
			:remote="true"
			:remote-callback="getTerms"
			:remote-trigger="2"
			size="fullwidth"
			v-model="querySettings['include_terms_ids']"
			:conditions="[
				{
					input: this.querySettings['current_query'],
					compare: 'equal',
					value: 'false',
				},
			]">
		</cx-vui-f-select>

		<cx-vui-f-select
			name="exclude_terms_ids"
			label="<?php _e( 'Exclude Terms', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			multiple="true"
			:remote="true"
			:remote-callback="getTerms"
			:remote-trigger="2"
			size="fullwidth"
			v-model="querySettings['exclude_terms_ids']"
			:conditions="[
				{
					input: this.querySettings['current_query'],
					compare: 'equal',
					value: 'false',
				},
			]">
		</cx-vui-f-select>

		<cx-vui-f-select
			name="exclude_posts_ids"
			label="<?php _e( 'Exclude Posts', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			multiple="true"
			:remote="true"
			:remote-callback="getPosts"
			:remote-trigger="2"
			size="fullwidth"
			v-model="querySettings['exclude_posts_ids']"
			:conditions="[
				{
					input: this.querySettings['current_query'],
					compare: 'equal',
					value: 'false',
				},
			]">
		</cx-vui-f-select>

		<cx-vui-input
			name="custom_fields_source"
			label="<?php _e( 'Search in custom fields', 'jet-search' ); ?>"
			description="<?php _e( 'Set comma separated custom fields keys list (_sku, _price, etc.)', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			size="fullwidth"
			type="text"
			v-model="querySettings['custom_fields_source']">
		</cx-vui-input>

		<cx-vui-switcher
			name="sentence"
			label="<?php _e( 'Sentence Search', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			return-true="true"
			return-false="false"
			v-model="querySettings['sentence']">
		</cx-vui-switcher>

		<cx-vui-switcher
			name="search_in_taxonomy"
			label="<?php _e( 'Search in taxonomy terms', 'jet-search' ); ?>"
			description="<?php _e( 'Include in the search results the posts containing the terms of the selected taxonomies with the search phrase in the term name', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			return-true="true"
			return-false="false"
			v-model="querySettings['search_in_taxonomy']">
		</cx-vui-switcher>

		<cx-vui-f-select
			name="search_in_taxonomy_source"
			label="<?php _e( 'Taxonomies', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			multiple="true"
			:options-list="taxonomiesListExtended"
			size="fullwidth"
			v-model="querySettings['search_in_taxonomy_source']"
			:conditions="[
				{
					input: this.querySettings['search_in_taxonomy'],
					compare: 'equal',
					value: 'true',
				},
			]">
		</cx-vui-f-select>

		<cx-vui-select
			name="results_order_by"
			label="<?php _e( 'Results Order By', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			size="fullwidth"
			:options-list="[
				{
					value: 'relevance',
					label: '<?php _e( 'Relevance', 'jet-search' ); ?>',
				},
				{
					value: 'ID',
					label: '<?php _e( 'ID', 'jet-search' ); ?>',
				},
				{
					value: 'author',
					label: '<?php _e( 'Author', 'jet-search' ); ?>',
				},
				{
					value: 'title',
					label: '<?php _e( 'Title', 'jet-search' ); ?>',
				},
				{
					value: 'date',
					label: '<?php _e( 'Date', 'jet-search' ); ?>',
				},
				{
					value: 'modified',
					label: '<?php _e( 'Last modified', 'jet-search' ); ?>',
				},
				{
					value: 'rand',
					label: '<?php _e( 'Rand', 'jet-search' ); ?>',
				},
				{
					value: 'comment_count',
					label: '<?php _e( 'Number of Comments (descending)', 'jet-search' ); ?>',
				},
				{
					value: 'menu_order',
					label: '<?php _e( 'Menu order', 'jet-search' ); ?>',
				},
			]"
			v-model="querySettings['results_order_by']">
		</cx-vui-select>

		<cx-vui-select
			name="results_order"
			label="<?php _e( 'Results Order', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			size="fullwidth"
			:options-list="[
				{
					value: 'asc',
					label: '<?php _e( 'ASC', 'jet-search' ); ?>',
				},
				{
					value: 'desc',
					label: '<?php _e( 'DESC', 'jet-search' ); ?>',
				},
			]"
			v-model="querySettings['results_order']">
		</cx-vui-select>

		<?php if ( class_exists( 'WooCommerce' ) ): ?>

			<cx-vui-switcher
				name="catalog_visibility"
				label="<?php _e( 'Use Product Catalog Visibility Settings', 'jet-search' ); ?>"
				:wrapper-css="[ 'equalwidth' ]"
				return-true="true"
				return-false="false"
				v-model="querySettings['catalog_visibility']">

			</cx-vui-switcher>

		<?php endif;?>

		<div class="cx-vui-subtitle cx-vui-subtitle--custom-page"><?php _e( 'Custom Results Page', 'jet-search' ); ?></div>

		<cx-vui-input
			name="search_results_url"
			label="<?php _e( 'Custom Search Results URL', 'jet-search' ); ?>"
			description="<?php _e( 'Link to the page where search results will be displayed.', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			size="fullwidth"
			type="text"
			v-model="querySettings['search_results_url']">
		</cx-vui-input>

		<cx-vui-input
			name="search_query_param"
			label="<?php _e( 'Search Query Param', 'jet-search' ); ?>"
			description="<?php _e( 'A unique query parameter name meant for redirecting to a custom search results page. Avoid using the standard \'s\' parameter in the name, as some plugins may interact with similar parameters such as \'search\', \'_s\', \'jsearch\', \'jet_ajax_search_settings\', \'jet_search_suggestions_settings\'', 'jet-search' ); ?>"
			:wrapper-css="[ 'equalwidth' ]"
			size="fullwidth"
			type="text"
			v-model="querySettings['search_query_param']"
			@input="searchQueryParamValidation( $event, querySettings['search_query_param'] )"
			:placeholder="placeholders.searchQueryParam"
			:error="searchQueryParamNameError"
			:conditions="[
				{
					input: this.querySettings['search_results_url'],
					compare: 'not_equal',
					value: '',
				},
			]">
		</cx-vui-input>

		<cx-vui-component-wrapper
			:wrapper-css="[ 'jet-search-settings' ]"
			:conditions="[
				{
					input: this.querySettings['search_results_url'],
					compare: 'not_equal',
					value: '',
				},
			]">
			<div class="cx-vui-component__label">Please note!</div>
			<div class="cx-vui-component__desc">You need to set the same post type(s) as a source for Ajax Search and for the widget (element/block) on the custom results page where you want to apply the search query. The search query will be applied to all widgets having the same post type in the source as set for Ajax Search.</div>
		</cx-vui-component-wrapper>

		<cx-vui-button
			class="jet-ajax-search-save-options-button"
			@click="saveQuerySettings()"
			button-style="accent"
			size="mini"
			:disabled="!isValidated"
		>
			<template slot="label"><?php esc_html_e('Save Options', 'jet-search'); ?></template>
		</cx-vui-button>
	</div>
</div>
<?php
// phpcs:enable
?>