
// global ajaxurl, dpppLocalizedOptions, dpppCopiedRules

var dpppCopiedRules = [];

/*
 * Shows and hides a hint text
 * @param {Number} id
 */
function dpppShowHideHint( id ) {
    'use strict';
    if ( jQuery( '#dppp-hint-' + id ).css( 'display' ) === 'none' ) {
        jQuery( '#dppp-hint-' + id ).css( 'display', 'block' );
        jQuery( '#dppp-hint-link-' + id ).html( dpppLocalizedOptions.hideHint );
    } else {
        jQuery( '#dppp-hint-' + id ).css( 'display', 'none' );
        jQuery( '#dppp-hint-link-' + id ).html( dpppLocalizedOptions.readMore );
    }
}

// Makes an ajax request to save the plugin settings and shows a loading icon while working
function dpppSaveSettings() {
    'use strict';
    var data, settingDebugMode, settingInactivePlugins, settingCompletelyRemove, settingGroupsFirst, settingTrailingSlash, settingBackEnd, settingParameters,
        settingParametersCustom, settingChosenParameters, settingPluginIcons, settingLocalMode, settingRulesFirst, settingHideInGroup, settingPriority,
        settingVisual, settingEditPost, settingMenuCacheTime;
    jQuery( '#dppp-save-settings' ).attr( 'disabled', true );
    jQuery( '#dppp-save-settings' ).attr( 'onclick', 'void(0)' );
    jQuery( '#dppp-loading-settings' ).css( 'visibility', 'visible' );
    jQuery( '#dppp-loading-settings' ).addClass( 'dppp-rotate' );
    jQuery( '#dppp-status-save' ).html( '' );
    jQuery( '#dppp-status-save' ).removeClass( 'dppp-red dppp-green' );
    settingTrailingSlash = jQuery( '#dppp-trailing-slash' ).val();
    settingParameters = jQuery( '#dppp-uri-parameters' ).val();
    settingParametersCustom = jQuery( '#dppp-uri-parameters-custom' ).val();
    settingChosenParameters = jQuery( '#dppp-chosen-uri-parameters' ).val();
    settingDebugMode = jQuery( '#dppp-debug-mode' ).val();
    settingInactivePlugins = jQuery( '#dppp-inactive-plugins' ).val();
    settingCompletelyRemove = jQuery( '#dppp-completely-remove' ).val();
    settingGroupsFirst = jQuery( '#dppp-groups-first' ).val();
    settingBackEnd = jQuery( '#dppp-affect-back-end' ).val();
    settingPluginIcons = jQuery( '#dppp-plugin-icons' ).val();
    settingLocalMode = jQuery( '#dppp-local-mode' ).val();
    settingRulesFirst = jQuery( '#dppp-rules-first' ).val();
    settingHideInGroup = jQuery( '#dppp-hide-plugins-in-group' ).val();
    settingPriority = jQuery( '#dppp-priority' ).val();
    settingVisual = jQuery( '#dppp-affect-visual-editors' ).val();
    settingEditPost = jQuery( '#dppp-edit-post-parameter' ).val();
    settingMenuCacheTime = jQuery( '#dppp-admin-menu-cache-time' ).val();

    data = {
        'action': 'dppp_save_settings_action',
        'debug_mode': settingDebugMode,
        'inactive_plugins': settingInactivePlugins,
        'completely_remove': settingCompletelyRemove,
        'groups_first': settingGroupsFirst,
        'trailing_slash': settingTrailingSlash,
        'affect_back_end': settingBackEnd,
        'uri_parameters': settingParameters,
        'uri_parameters_custom': settingParametersCustom,
        'chosen_uri_parameters': settingChosenParameters,
        'plugin_icon_images': settingPluginIcons,
        'local_mode': settingLocalMode,
        'rules_first': settingRulesFirst,
        'hide_in_group': settingHideInGroup,
        'priority': settingPriority,
        'affect_visual_editors': settingVisual,
        'edit_post_parameter': settingEditPost,
        'admin_menu_cache_time': settingMenuCacheTime,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
            dpppSavedSettingsError();
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
            dpppSavedSettingsError();
        } else if ( 'invalid-data' === response ) {
            alert( dpppLocalizedOptions.errorData );
            dpppSavedSettingsError();
        } else if ( 'done' === response || 'done-recreate-cache' === response ) {
            dpppSavedSettingsDone();
        } else {
            alert( dpppLocalizedOptions.errorResponse );
            dpppSavedSettingsError();
        }
        jQuery( '#dppp-save-settings' ).attr( 'disabled', false );
        jQuery( '#dppp-save-settings' ).attr( 'onclick', 'dpppSaveSettings()' );
        jQuery( '#dppp-loading-settings' ).css( 'visibility', 'hidden' );
        jQuery( '#dppp-loading-settings' ).removeClass( 'dppp-rotate' );
        if ( 'done' === response ) {
            window.location.reload( false );
        }

        // If we just turned on the admin menu cache and saved the settings, we will create the cache and reload
        if ( 'done-recreate-cache' === response ) {
            window.location = dpppLocalizedOptions.recreateCacheURL;
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        dpppSavedSettingsError();
        jQuery( '#dppp-save-settings' ).attr( 'disabled', false );
        jQuery( '#dppp-save-settings' ).attr( 'onclick', 'dpppSaveSettings()' );
        jQuery( '#dppp-loading-settings' ).css( 'visibility', 'hidden' );
        jQuery( '#dppp-loading-settings' ).removeClass( 'dppp-rotate' );
    });
}

// Shows a red error message when saving the settings failed
function dpppSavedSettingsError() {
    'use strict';
    jQuery( '#dppp-status-save' ).html( dpppLocalizedOptions.error );
    jQuery( '#dppp-status-save' ).addClass( 'dppp-red' ).removeClass( 'dppp-green' );
}

// Shows a green message when saving the settings was done
function dpppSavedSettingsDone() {
    'use strict';
    jQuery( '#dppp-status-save' ).html( dpppLocalizedOptions.done );
    jQuery( '#dppp-status-save' ).addClass( 'dppp-green' ).removeClass( 'dppp-red' );
}

/*
 * Makes an ajax request to delete a plugin rule
 * @param {Number} ruleID
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 */
function dpppDeleteRule( ruleID, pluginFile, pluginOrGroupHash ) {
    'use strict';
    var data, confirmAction;
    confirmAction = confirm( dpppLocalizedOptions.confirmDeleteRule );
    if ( true !== confirmAction ) {
        return;
    }
    jQuery( '#dppp-plugin-rules-' + pluginOrGroupHash + ' .dppp-dashicon-action-link' ).addClass( 'dppp-unclickable' );
    jQuery( '#dppp-delete-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-no' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_delete_rule_action',
        'rule_id': ruleID,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'done' === response ) {
            jQuery( '#dppp-rule-row-' + ruleID ).addClass( 'dppp-highlight-red' );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
        dpppUpdateRulesContent( pluginFile, pluginOrGroupHash, 'delete', '', '' );
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-plugin-rules-' + pluginOrGroupHash + ' .dppp-dashicon-action-link' ).removeClass( 'dppp-unclickable' );
        jQuery( '#dppp-delete-rule-' + ruleID + ' .dashicons' ).addClass( 'dashicons-no' ).removeClass( 'dashicons-update' );
    });
}

/*
 * Makes an ajax request to pause a plugin rule
 * @param {Number} ruleID
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 */
function dpppPauseRule( ruleID, pluginFile, pluginOrGroupHash ) {
    'use strict';
    var data;
    jQuery( '#dppp-plugin-rules-' + pluginOrGroupHash + ' .dppp-dashicon-action-link' ).addClass( 'dppp-unclickable' );
    jQuery( '#dppp-pause-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-controls-pause' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_pause_rule_action',
        'rule_id': ruleID,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'done' === response ) {
            jQuery( '#dppp-rule-row-' + ruleID ).addClass( 'dppp-rule-row-paused' );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
        dpppUpdateRulesContent( pluginFile, pluginOrGroupHash, 'pause', '', '' );
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-plugin-rules-' + pluginOrGroupHash + ' .dppp-dashicon-action-link' ).removeClass( 'dppp-unclickable' );
        jQuery( '#dppp-pause-rule-' + ruleID + ' .dashicons' ).addClass( 'dashicons-controls-pause' ).removeClass( 'dashicons-update' );
    });
}

/*
 * Makes an ajax request to start a paused plugin rule
 * @param {Number} ruleID
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 */
function dpppStartRule( ruleID, pluginFile, pluginOrGroupHash ) {
    'use strict';
    var data;
    jQuery( '#dppp-plugin-rules-' + pluginOrGroupHash + ' .dppp-dashicon-action-link' ).attr( 'href', '#' );
    jQuery( '#dppp-start-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-controls-play' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_start_rule_action',
        'rule_id': ruleID,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'done' === response ) {
            jQuery( '#dppp-rule-row-' + ruleID ).removeClass( 'dppp-rule-row-paused' );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
        dpppUpdateRulesContent( pluginFile, pluginOrGroupHash, 'start', '', '' );
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        dpppUpdateRulesContent( pluginFile, pluginOrGroupHash, 'start', '', '' );
    });
}

/*
 * Makes an ajax request to generate and show the form for adding a new rule. Also handles the form changes and button click.
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 */
function dpppAddNewRule( pluginFile, pluginOrGroupHash ) {
    'use strict';
    var data, saveHref;
    saveHref = jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash ).attr( 'href' );
    jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash ).attr( 'href', '#' );
    jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash + ' .dashicons' ).removeClass( 'dashicons-plus' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_add_new_rule_action',
        'plugin_file': pluginFile,
        'hash': pluginOrGroupHash,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        var id, parts, uriType, pageID, selectedPages = '';
        jQuery( '#dppp-results' ).html( response );
        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'block' );
        jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash ).attr( 'href', saveHref );
        jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-plus' );
        dpppCountSelectedPages( selectedPages );

        // A checkbox selecting a page was checked/unchecked
        jQuery( '.dppp-page-checkbox' ).change( function() {
            id = jQuery( this ).attr( 'id' );
            parts = id.split( '-' );
            pageID = parts[3];
            if ( this.checked ) {
                selectedPages += pageID + ',';
                jQuery( '#dppp-page-paragraph-' + pageID ).addClass( 'dppp-selected-element' );
            } else {
                selectedPages = selectedPages.replace( pageID + ',', '' );
                jQuery( '#dppp-page-paragraph-' + pageID ).removeClass( 'dppp-selected-element' );
            }
            dpppCountSelectedPages( selectedPages );
        });

        // The URI type dropdown menu was changed
        jQuery( '#dppp-select-uri-type' ).change( function() {
            uriType = jQuery( this ).val();
            if ( 'page' === uriType ) {
                jQuery( '#dppp-page-uri-type' ).css( 'display', 'block' );
                jQuery( '#dppp-custom-uri-type' ).css( 'display', 'none' );
            } else {
                jQuery( '#dppp-page-uri-type' ).css( 'display', 'none' );
                jQuery( '#dppp-custom-uri-type' ).css( 'display', 'block' );
            }
        });

        // The button to add the rule was clicked
        jQuery( '#dppp-button-add-selected-pages' ).click( function(){
            dpppSaveRuleData( pluginFile, pluginOrGroupHash, selectedPages );
        });

        // The button to close the box was clicked
        jQuery( '#dppp-button-close-add-new' ).click( function(){
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
        });

        // The affected devices dropdown menu was changed, so we may show a notice
        jQuery( '#dppp-select-devices' ).change( function() {
            if ( jQuery( this ).val() !== 'all' ) {
                jQuery( '#dppp-notice-devices' ).removeClass( 'dppp-display-none' );
                jQuery( '#dppp-read-more-devices' ).addClass( 'dppp-display-none' );
            } else {
                jQuery( '#dppp-notice-devices' ).addClass( 'dppp-display-none' );
                jQuery( '#dppp-read-more-devices' ).removeClass( 'dppp-display-none' );
            }
        });
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash ).attr( 'href', saveHref );
        jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-plus' );
    });
}

/*
 * Makes an ajax request to save the data for the new rule we are adding.
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 * @param {String} pages
 */
function dpppSaveRuleData( pluginFile, pluginOrGroupHash, pages ) {
    'use strict';
    var saveButtonValue, data, deactivationType, uriType, customCondition, customValue, devices, selectTranslatedPagesWPML, loop, moreCustomConditions,
        moreCustomValues, addConditionsOnclick, maxNumberCondition, note, customFunction;

    // We disable the button and show a loading message
    jQuery( '#dppp-button-add-selected-pages' ).prop( 'disabled', true );
    saveButtonValue = jQuery( '#dppp-button-add-selected-pages' ).attr( 'value' );
    jQuery( '#dppp-button-add-selected-pages' ).attr( 'value', dpppLocalizedOptions.loading );

    // We get the form data
    deactivationType = jQuery( '#dppp-select-deactivation-type' ).val();
    uriType = jQuery( '#dppp-select-uri-type' ).val();
    customCondition = jQuery( '#dppp-custom-uri-select-condition' ).val();
    customValue = jQuery( '#dppp-custom-uri-value' ).val();
    devices = jQuery( '#dppp-select-devices' ).val();
    note = jQuery( '#dppp-rule-note' ).val();
    customFunction = jQuery( '#dppp-custom-condition-function' ).val();
    selectTranslatedPagesWPML = 'no';
    if ( jQuery( '#dppp-select-wpml-translated-pages' ).length > 0 ) {
        if ( jQuery( '#dppp-select-wpml-translated-pages' ).is( ':checked' ) ) {
            selectTranslatedPagesWPML = 'yes';
        }
    }

    // Time to get the additional custom conditions if any
    moreCustomConditions = '';
    moreCustomValues = '';
    addConditionsOnclick = jQuery( '#dppp-add-more-conditions-link' ).attr( 'onclick' );
    if ( addConditionsOnclick !== 'dpppAddMoreConditions( 2 )' ) {
        maxNumberCondition = addConditionsOnclick.replace( 'dpppAddMoreConditions( ', '' );
        maxNumberCondition = parseInt( maxNumberCondition.replace( ' )', '' ) );
        for ( loop = 2; loop < maxNumberCondition; loop++ ) {
            if ( jQuery( '#dppp-' + loop + '-uri-condition-container' ).length > 0 ) {
                moreCustomConditions += '--dppp-or--' + jQuery( '#dppp-' + loop + '-custom-uri-select-condition' ).val();
                moreCustomValues += '--dppp-or--' + jQuery( '#dppp-' + loop + '-custom-uri-value' ).val();
            }
        }
    }

    data = {
        'action': 'dppp_save_rule_data_action',
        'pages': pages,
        'plugin_file': pluginFile,
        'hash': pluginOrGroupHash,
        'deactivation_type': deactivationType,
        'uri_type': uriType,
        'custom_condition': customCondition,
        'custom_value': customValue,
        'more_custom_conditions': moreCustomConditions,
        'more_custom_values': moreCustomValues,
        'devices': devices,
        'note': note,
        'custom_function': customFunction,
        'select_translated_pages_wpml': selectTranslatedPagesWPML,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {
        var saveHref;
        response = response.trim();
        jQuery( '#dppp-button-add-selected-pages' ).prop( 'disabled', false );
        jQuery( '#dppp-button-add-selected-pages' ).attr( 'value', saveButtonValue );
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'invalid-data' === response ) {
            alert( dpppLocalizedOptions.errorData );
        } else if ( 'select-page' === response ) {
            alert( dpppLocalizedOptions.errorSelectPage );
        } else if ( 'enter-uri' === response ) {
            alert( dpppLocalizedOptions.errorEnterURI );
        } else if ( 'could-not-check-if-exists' === response ) {
            alert( dpppLocalizedOptions.errorCheckExists );
        } else if ( 'group-does-not-exist' === response ) {
            alert( dpppLocalizedOptions.errorGroupNotExist );
        } else if ( 'already-exists' === response ) {
            alert( dpppLocalizedOptions.errorExists );
        } else if ( 'invalid-regex' === response ) {
            alert( dpppLocalizedOptions.errorRegex );
        } else if ( 'uri-not-url' === response ) {
            alert( dpppLocalizedOptions.errorURL );
        } else if ( 'could-not-insert' === response ) {
            alert( dpppLocalizedOptions.errorInsert );
        } else if ( response.substr( 0, 6 ) === '[done]' ) {
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
            saveHref = jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash ).attr( 'href' );
            jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash ).attr( 'href', '#' );
            jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash + ' .dashicons' ).removeClass( 'dashicons-plus' ).addClass( 'dashicons-update' );
            jQuery( '#dppp-inner-box-' + pluginOrGroupHash + ' .dppp-plugin-or-group-start-rules-link' ).removeClass( 'dppp-display-none' );
            jQuery( '#dppp-inner-box-' + pluginOrGroupHash + ' .dppp-plugin-or-group-pause-rules-link' ).removeClass( 'dppp-display-none' );
            jQuery( '#dppp-inner-box-' + pluginOrGroupHash + ' .dppp-plugin-or-group-delete-rules-link' ).removeClass( 'dppp-display-none' );
            dpppUpdateRulesContent( pluginFile, pluginOrGroupHash, 'add', saveHref, response.replace( '[done]', '' ) );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-button-add-selected-pages' ).prop( 'disabled', false );
        jQuery( '#dppp-button-add-selected-pages' ).attr( 'value', saveButtonValue );
    });
}

/*
 * Makes an ajax request to show the box explaining a rule
 * @param {Number} ruleID
 */
function dpppExplainRule( ruleID ) {
    'use strict';
    var data, saveHref;
    saveHref = jQuery( '#dppp-explain-rule-' + ruleID ).attr( 'href' );
    jQuery( '#dppp-explain-rule-' + ruleID ).attr( 'href', '#' );
    jQuery( '#dppp-explain-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-info' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_explain_rule_action',
        'rule_id': ruleID,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        jQuery( '#dppp-explain-rule-' + ruleID ).attr( 'href', saveHref );
        jQuery( '#dppp-explain-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-info' );
        jQuery( '#dppp-results' ).html( response );
        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'block' );
        jQuery( '#dppp-button-close-explain' ).click( function(){
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
        });
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-explain-rule-' + ruleID ).attr( 'href', saveHref );
        jQuery( '#dppp-explain-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-info' );
    });
}

/*
 * Makes an ajax request to update the rules data in the layer for a chosen plugin
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 * @param {String} saveHref
 * @param {String} highlightID
 */
function dpppUpdateRulesContent( pluginFile, pluginOrGroupHash, afterAction, saveHref, highlightID ) {
    'use strict';
    var data;
    data = {
        'action': 'dppp_update_rules_content_action',
        'plugin_file': pluginFile,
        'hash': pluginOrGroupHash,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        var parts;
        response = response.trim();
        jQuery( '#dppp-plugin-rules-' + pluginOrGroupHash ).html( response );
        if ( '' !== response ) {
            jQuery( '#dppp-plugin-rules-' + pluginOrGroupHash ).removeClass( 'dppp-display-none' );
        } else {
            jQuery( '#dppp-plugin-rules-' + pluginOrGroupHash ).addClass( 'dppp-display-none' );

            // Since there are no rules left, we hide some plugin actions
            jQuery( '#dppp-inner-box-' + pluginOrGroupHash + ' .dppp-plugin-or-group-start-rules-link' ).addClass( 'dppp-display-none' );
            jQuery( '#dppp-inner-box-' + pluginOrGroupHash + ' .dppp-plugin-or-group-pause-rules-link' ).addClass( 'dppp-display-none' );
            jQuery( '#dppp-inner-box-' + pluginOrGroupHash + ' .dppp-plugin-or-group-delete-rules-link' ).addClass( 'dppp-display-none' );
        }
        if ( '' !== saveHref ) {
            jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash ).attr( 'href', saveHref );
            jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-plus' );
        }

        // If there are some rules to highlight we do that
        if ( '' !== highlightID ) {
            if ( highlightID.indexOf( ',' ) != -1 ) {
                parts = highlightID.split( ',' );
                if ( 'add' === afterAction ) {
                    parts.forEach( function( currentID ) {
                        jQuery( '#dppp-rule-row-' + currentID ).addClass( 'dppp-highlight' );
                        setTimeout( function() { jQuery( '#dppp-rule-row-' + currentID ).removeClass( 'dppp-highlight' ); }, 150 );
                    });
                }
                if ( 'edit' === afterAction ) {
                    parts.forEach( function( currentID ) {
                        jQuery( '#dppp-rule-row-' + currentID ).addClass( 'dppp-highlight-yellow' );
                        setTimeout( function() { jQuery( '#dppp-rule-row-' + currentID ).removeClass( 'dppp-highlight-yellow' ); }, 150 );
                    });
                }
            } else {
                if ( 'add' === afterAction ) {
                    jQuery( '#dppp-rule-row-' + highlightID ).addClass( 'dppp-highlight' );
                    setTimeout( function() { jQuery( '#dppp-rule-row-' + highlightID ).removeClass( 'dppp-highlight' ); }, 150 );
                }
                if ( 'edit' === afterAction ) {
                    jQuery( '#dppp-rule-row-' + highlightID ).addClass( 'dppp-highlight-yellow' );
                    setTimeout( function() { jQuery( '#dppp-rule-row-' + highlightID ).removeClass( 'dppp-highlight-yellow' ); }, 150 );
                }
            }
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        if ( '' !== saveHref ) {
            jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash ).attr( 'href', saveHref );
            jQuery( '#dppp-add-rule-link-' + pluginOrGroupHash + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-plus' );
        }
    });
}

// Filters the plugins (and groups) by name when something is entered in a text field to quickly find plugins. It hides the ones that don't contain this string.
function dpppFindPlugins() {
    'use strict';
    var id, pluginName, toFind, groupPluginNames, foundInGroupPlugins;
    toFind = jQuery( '#dppp-find-plugins' ).val().toLowerCase();
    jQuery( '.dppp-inner-box' ).each( function( positionInner, objectInner ) {
        id = jQuery( objectInner ).attr( 'id' );
        if ( jQuery( '#' + id + ' .dppp-row-name-only' ).length > 0 ) {
            pluginName = jQuery( '#' + id + ' .dppp-row-name-only' ).html().toLowerCase();

            // If this is a plugin group, we will search in the plugin names in it as well
            foundInGroupPlugins = 'no';
            if ( jQuery( '#' + id + ' .dppp-plugin-name-in-group' ).length > 0 ) {
                groupPluginNames = [];
                jQuery( '#' + id + ' .dppp-plugin-name-in-group' ).each( function( positionName, objectName ) {
                    groupPluginNames.push( jQuery( objectName ).html().toLowerCase() );
                });
                jQuery.each( groupPluginNames, function( index, item ) {
                    if ( item.toLowerCase().indexOf( toFind ) > -1 ) {
                        foundInGroupPlugins = 'yes';
                        return false;
                    }
                });
            }

            if ( 'yes' === foundInGroupPlugins || pluginName.indexOf( toFind ) > -1 ) {
                jQuery( objectInner ).css( 'display', 'inline-block' );
            } else {
                jQuery( objectInner ).css( 'display', 'none' );
            }
        }
    });

    // We decide whether to show the icon with link that clears the text field
    if ( toFind !== '' ) {
        if ( jQuery( '#dppp-clear-find-plugins' ).hasClass( 'dppp-display-none' ) ) {
            jQuery( '#dppp-clear-find-plugins' ).removeClass( 'dppp-display-none' );
        }
    } else {
        if ( ! jQuery( '#dppp-clear-find-plugins' ).hasClass( 'dppp-display-none' ) ) {
            jQuery( '#dppp-clear-find-plugins' ).addClass( 'dppp-display-none' );
        }
    }
}

// Clears the text field for finding plugins and shows all plugins
function dpppClearFindPlugins() {
    'use strict';
    jQuery( '#dppp-find-plugins' ).val( '' );
    dpppFindPlugins();
}

// Makes an ajax request to generate and show the form for adding a new plugin group. Also handles the form changes and button click.
function dpppAddNewPluginGroup() {
    'use strict';
    var data, saveHref;
    saveHref = jQuery( '#dppp-add-plugin-group-link' ).attr( 'href' );
    jQuery( '#dppp-add-plugin-group-link' ).attr( 'href', '#' );
    jQuery( '#dppp-add-plugin-group-link .dashicons' ).removeClass( 'dashicons-plus' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_add_new_plugin_group_action',
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        var id, parts, pluginHash, selectedPlugins = '';
        jQuery( '#dppp-results' ).html( response );
        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'block' );
        jQuery( '#dppp-add-plugin-group-link' ).attr( 'href', saveHref );
        jQuery( '#dppp-add-plugin-group-link .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-plus' );
        dpppCountSelectedPlugins( selectedPlugins );

        // A checkbox selecting a plugin was checked/unchecked
        jQuery( '.dppp-plugin-checkbox' ).change( function() {
            id = jQuery( this ).attr( 'id' );
            parts = id.split( '-' );
            pluginHash = parts[3];
            if ( this.checked ) {
                selectedPlugins += pluginHash + '_';
                jQuery( '#dppp-plugin-paragraph-' + pluginHash ).addClass( 'dppp-selected-element' );
            } else {
                selectedPlugins = selectedPlugins.replace( pluginHash + '_', '' );
                jQuery( '#dppp-plugin-paragraph-' + pluginHash ).removeClass( 'dppp-selected-element' );
            }
            dpppCountSelectedPlugins( selectedPlugins );
        });

        // The button to add the group was clicked
        jQuery( '#dppp-button-add-selected-plugins' ).click( function(){
            dpppSavePluginGroupData( selectedPlugins );
        });

        // The button to close the box was clicked
        jQuery( '#dppp-button-close-add-new' ).click( function(){
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );

        });
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-add-plugin-group-link' ).attr( 'href', saveHref );
        jQuery( '#dppp-add-plugin-group-link .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-plus' );
    });
}

/*
 * Makes an ajax request to save the data for the new plugin group we are adding.
 * @param {String} plugins
 */
function dpppSavePluginGroupData( plugins ) {
    'use strict';
    var saveButtonValue, data, groupName;

    // We disable the button and show a loading message
    jQuery( '#dppp-button-add-selected-plugins' ).prop( 'disabled', true );
    saveButtonValue = jQuery( '#dppp-button-add-selected-plugins' ).attr( 'value' );
    jQuery( '#dppp-button-add-selected-plugins' ).attr( 'value', dpppLocalizedOptions.loading );

    groupName = jQuery( '#dppp-plugin-group-name' ).val();
    data = {
        'action': 'dppp_save_plugin_group_data_action',
        'plugins': plugins,
        'group_name': groupName,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {
        var saveHref;
        response = response.trim();
        jQuery( '#dppp-button-add-selected-plugins' ).prop( 'disabled', false );
        jQuery( '#dppp-button-add-selected-plugins' ).attr( 'value', saveButtonValue );
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'already-exists-group' === response ) {
            alert( dpppLocalizedOptions.errorExistsGroup );
        } else if ( 'at-least-two-plugins' === response ) {
            alert( dpppLocalizedOptions.errorAtLeastTwoPlugins );
        } else if ( 'invalid-data' === response ) {
            alert( dpppLocalizedOptions.errorData );
        } else if ( response.substr( 0, 6 ) === '[done]' ) {
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
            saveHref = jQuery( '#dppp-add-plugin-group-link' ).attr( 'href' );
            jQuery( '#dppp-add-plugin-group-link' ).attr( 'href', '#' );
            jQuery( '#dppp-add-plugin-group-link .dashicons' ).removeClass( 'dashicons-plus' ).addClass( 'dashicons-update' );
            dpppUpdatePluginGroupsContent( 'add', saveHref );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-button-add-selected-plugins' ).prop( 'disabled', false );
        jQuery( '#dppp-button-add-selected-plugins' ).attr( 'value', saveButtonValue );
    });
}

/*
 * Updates the plugin groups section with fresh data
 * @param {String} afterAction
 * @param {String} saveHref
 */
function dpppUpdatePluginGroupsContent( afterAction, saveHref ) {
    'use strict';
    var data;
    data = {
        'action': 'dppp_update_plugin_groups_action',
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {
        response = response.trim();
        jQuery( '#dppp-plugin-groups-section' ).html( response );
        if ( 'add' === afterAction ) {
            jQuery( '#dppp-add-plugin-group-link' ).attr( 'href', saveHref );
            jQuery( '#dppp-add-plugin-group-link .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-plus' );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        if ( 'add' === afterAction ) {
            jQuery( '#dppp-add-plugin-group-link' ).attr( 'href', saveHref );
            jQuery( '#dppp-add-plugin-group-link .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-plus' );
        }
    });
}

/*
 * Deletes a plugin group and its rules
 * @param {String} groupHash
 */
function dpppDeletePluginGroup( groupHash ) {
    'use strict';
    var data, confirmAction, saveHref;
    confirmAction = confirm( dpppLocalizedOptions.confirmDeleteGroup );
    if ( true !== confirmAction ) {
        return;
    }
    saveHref = jQuery( '#dppp-delete-group-link-' + groupHash ).attr( 'href' );
    jQuery( '#dppp-delete-group-link-' + groupHash ).attr( 'href', '#' );
    jQuery( '#dppp-delete-group-link-' + groupHash + ' .dashicons' ).removeClass( 'dashicons-trash' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_delete_plugin_group_action',
        'group_hash': groupHash,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {
        response = response.trim();
        jQuery( '#dppp-delete-group-link-' + groupHash ).attr( 'href', saveHref );
        jQuery( '#dppp-delete-group-link-' + groupHash + ' .dashicons' ).addClass( 'dashicons-trash' ).removeClass( 'dashicons-update' );
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'group-does-not-exist' === response ) {
            alert( dpppLocalizedOptions.errorGroupNotExist );
        } else if ( response.substr( 0, 6 ) === '[done]' ) {
            dpppUpdatePluginGroupsContent( 'delete', '' );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-delete-group-link-' + groupHash ).attr( 'href', saveHref );
        jQuery( '#dppp-delete-group-link-' + groupHash + ' .dashicons' ).addClass( 'dashicons-trash' ).removeClass( 'dashicons-update' );
    });
}

/*
 * Performs global actions (delete all rules, pause all rules, start all rules, hide group plugins, show group plugins)
 * @param {String} globalAction
 * @param {String} taskID
 */
function dpppGlobalActions( globalAction, taskID ) {
    'use strict';
    var data, confirmAction, saveHref, saveButtonValue, confirmAbort;

    // We ask for a different confirmation based on the action performed (for some no confirmation is needed)
    if ( 'delete-all-rules' === globalAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmDeleteAllRules );
    } else if ( 'pause-all-rules' === globalAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmPauseAllRules );
    } else if ( 'start-all-rules' === globalAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmStartAllRules );
    } else if ( 'hide-group-plugins' === globalAction ) {
        confirmAction = true;
    } else if ( 'show-group-plugins' === globalAction ) {
        confirmAction = true;
    } else if ( 'execute-export-rules' === globalAction ) {
        confirmAction = true;
    } else if ( 'execute-import-rules' === globalAction ) {
        confirmAction = true;
    } else if ( 'export-rules' === globalAction ) {
        confirmAction = true;

        jQuery( '#dppp-results' ).html( jQuery( '#dppp-export-rules-hidden-form' ).html() );
        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'block' );

        // The button to close the box was clicked
        jQuery( '#dppp-button-close-export-rules' ).click( function(){
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );

        });

        // The button to export the rules was clicked
        jQuery( '#dppp-button-export-rules' ).click( function(){
            dpppGlobalActions( 'execute-export-rules', 'none' );
        });

        return;

    } else if ( 'import-rules' === globalAction ) {
        confirmAction = true;

        jQuery( '#dppp-results' ).html( jQuery( '#dppp-import-rules-hidden-form' ).html() );
        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'block' );
                                   
        // The button to close the box was clicked
        jQuery( '#dppp-button-close-import-rules' ).click( function(){

            // If it was clicked while a request is running, we ask to confirm because it will abort the task if not finished after the request is done
            if ( jQuery( '#dppp-results #dppp-button-import-rules' ).attr( 'disabled' ) === 'disabled' ) {
                confirmAbort = confirm( dpppLocalizedOptions.confirmAbortImport );
                if ( true === confirmAbort ) {
                    jQuery( '#dppp-results' ).html( '' );
                    jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
                    window.location.reload( false );
                }
            } else {
                jQuery( '#dppp-results' ).html( '' );
                jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
            }
        });

        // The button to import the rules was clicked
        jQuery( '#dppp-button-import-rules' ).click( function(){
            dpppGlobalActions( 'execute-import-rules', 'none' );
        });

        // When the checkbox to import into multiple sites is checked/unchecked we show/hide the rest of the settings
        jQuery( '#dppp-import-multiple-sites' ).change( function() {
            if ( this.checked ) {
                jQuery( '#dppp-results .dppp-import-affected-contain' ).removeClass( 'dppp-display-none' );
            } else {
                jQuery( '#dppp-results .dppp-import-affected-contain' ).addClass( 'dppp-display-none' );
            }
        });

        // If the option to affect all sites is selected we hide the field for site ids, otherwise we show it
        jQuery( '#dppp-import-affected-sites' ).change( function() {
            if ( 'all' === jQuery( this ).val() ) {
                jQuery( '#dppp-import-affected-ids' ).hide();
            } else {
                jQuery( '#dppp-import-affected-ids' ).show();
            }
        });                                                                                                  

        return;

    } else {
        alert( dpppLocalizedOptions.errorData );
        return;
    }
    if ( true !== confirmAction ) {
        return;
    }

    if ( 'execute-export-rules' !== globalAction && 'execute-import-rules' !== globalAction ) {
        saveHref = jQuery( '#dppp-' + globalAction + '-link' ).attr( 'href' );
        jQuery( '#dppp-' + globalAction + '-link' ).attr( 'href', '#' );
    }

    // We make changes to indicate loading based on the action
    if ( 'delete-all-rules' === globalAction ) {
        jQuery( '#dppp-' + globalAction + '-link .dashicons' ).removeClass( 'dashicons-no' ).addClass( 'dashicons-update' );
    } else if ( 'pause-all-rules' === globalAction ) {
        jQuery( '#dppp-' + globalAction + '-link .dashicons' ).removeClass( 'dashicons-controls-pause' ).addClass( 'dashicons-update' );
    } else if ( 'start-all-rules' === globalAction ) {
        jQuery( '#dppp-' + globalAction + '-link .dashicons' ).removeClass( 'dashicons-controls-play' ).addClass( 'dashicons-update' );
    } else if ( 'hide-group-plugins' === globalAction || 'show-group-plugins' === globalAction ) {
        jQuery( '#dppp-' + globalAction + '-link .dashicons' ).removeClass( 'dashicons-admin-plugins' ).addClass( 'dashicons-update' );
    } else if ( 'execute-export-rules' === globalAction ) {
        jQuery( '#dppp-results #dppp-button-export-rules' ).prop( 'disabled', true );
        saveButtonValue = jQuery( '#dppp-results #dppp-button-export-rules' ).attr( 'value' );
        jQuery( '#dppp-results #dppp-button-export-rules' ).attr( 'value', dpppLocalizedOptions.loading );
    } else if ( 'execute-import-rules' === globalAction && taskID === 'none' ) {
        jQuery( '#dppp-results #dppp-button-import-rules, #dppp-results #dppp-import-rules-textarea' ).prop( 'disabled', true );
        if ( jQuery( '#dppp-results #dppp-import-multiple-sites' ).length > 0 ) {
            jQuery( '#dppp-results #dppp-import-multiple-sites, #dppp-results #dppp-import-affected-sites, #dppp-results #dppp-import-affected-ids' )
                .prop( 'disabled', true );
        }
        saveButtonValue = jQuery( '#dppp-results #dppp-button-import-rules' ).attr( 'value' );
        jQuery( '#dppp-results #dppp-button-import-rules' ).attr( 'value', dpppLocalizedOptions.loading );
    }

    data = {
        'action': 'dppp_global_actions_action',
        'global_action': globalAction,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // If we are importing rules, we also add the import text data to the data object
    if ( 'execute-import-rules' === globalAction ) {
        data.text = jQuery( '#dppp-results #dppp-import-rules-textarea' ).val();

        if ( taskID !== 'none' ) {
            data.task_id = taskID;
        }

        data.multiple = 'No';
        if ( jQuery( '#dppp-results #dppp-import-multiple-sites' ).length > 0 ) {
            if ( jQuery( '#dppp-results #dppp-import-multiple-sites' ).is(':checked') ) {
                data.multiple = 'Yes';
                data.sites = jQuery( '#dppp-results #dppp-import-affected-sites' ).val();
                data.ids = jQuery( '#dppp-results #dppp-import-affected-ids' ).val();
            }
        }
    }

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {

        var responseObject, requestDoneSites, doneSites;

        response = response.trim();

        if ( 'execute-export-rules' !== globalAction && 'execute-import-rules' !== globalAction ) {
            jQuery( '#dppp-' + globalAction + '-link' ).attr( 'href', saveHref );
        }
        if ( 'delete-all-rules' === globalAction ) {
            jQuery( '#dppp-' + globalAction + '-link .dashicons' ).addClass( 'dashicons-no' ).removeClass( 'dashicons-update' );
        } else if ( 'pause-all-rules' === globalAction ) {
            jQuery( '#dppp-' + globalAction + '-link .dashicons' ).addClass( 'dashicons-controls-pause' ).removeClass( 'dashicons-update' );
        } else if ( 'start-all-rules' === globalAction ) {
            jQuery( '#dppp-' + globalAction + '-link .dashicons' ).addClass( 'dashicons-controls-play' ).removeClass( 'dashicons-update' );
        } else if ( 'hide-group-plugins' === globalAction || 'show-group-plugins' === globalAction ) {
            jQuery( '#dppp-' + globalAction + '-link .dashicons' ).addClass( 'dashicons-admin-plugins' ).removeClass( 'dashicons-update' );
        } else if ( 'execute-export-rules' === globalAction ) {
            jQuery( '#dppp-results #dppp-button-export-rules' ).prop( 'disabled', false );
            jQuery( '#dppp-results #dppp-button-export-rules' ).attr( 'value', saveButtonValue );
        } else if ( 'execute-import-rules' === globalAction ) {

            // The time was not enough to finish in one request, so we will continue in the next one
            if ( response.substr( 0, 12 ) === 'dppp-timeout' ) {

                // We parse the response into an object
                responseObject = jQuery.parseJSON( response.substring( 12 ) );

                // The number of sites done in the last request
                requestDoneSites = parseInt( responseObject.done );

                taskID = responseObject.taskID;

                if ( jQuery( '#dppp-hidden-import-sites-done' ).length <= 0 ) {
                    jQuery( '#dppp-results #dppp-button-import-rules' ).append( '<input type="hidden" id="dppp-hidden-import-sites-done" value="0" />' );
                }
                doneSites = parseInt( jQuery( '#dppp-hidden-import-sites-done' ).val() ) + requestDoneSites;
                jQuery( '#dppp-hidden-import-sites-done' ).val( doneSites );
                jQuery( '#dppp-results #dppp-button-import-rules' ).attr( 'value', dpppLocalizedOptions.doneSitesText + ' ' + doneSites );

                // We continue the task by calling the function again
                dpppGlobalActions( 'execute-import-rules', taskID );

            // We are done with the task, so we stop disabling the form elements
            } else {
                jQuery( '#dppp-results #dppp-button-import-rules, #dppp-results #dppp-import-rules-textarea' ).prop( 'disabled', false );
                if ( jQuery( '#dppp-results #dppp-import-multiple-sites' ).length > 0 ) {
                    jQuery( '#dppp-results #dppp-import-multiple-sites, #dppp-results #dppp-import-affected-sites, ' +
                        '#dppp-results #dppp-import-affected-ids' ).prop( 'disabled', false );
                }
                jQuery( '#dppp-results #dppp-button-import-rules' ).attr( 'value', saveButtonValue );
            }
        }

        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'invalid-data' === response ) {
            alert( dpppLocalizedOptions.errorData );
        } else if ( 'invalid-import-data' === response ) {
            alert( dpppLocalizedOptions.errorImportData );
        } else if ( 'invalid-multiple-settings' === response ) {
            alert( dpppLocalizedOptions.errorInvalidMultipleSettings );
        } else if ( 'cannot-continue-task' === response ) {
            alert( dpppLocalizedOptions.errorCannotContinue );
        } else if ( 'no-affected-sites' === response ) {
            alert( dpppLocalizedOptions.errorNoAffectedSites );
        } else if ( response.substr( 0, 6 ) === '[done]' ) {

            // Some actions require us to reload the page, and others only go refresh the groups section
            if ( 'delete-all-rules' === globalAction || 'pause-all-rules' === globalAction || 'start-all-rules' === globalAction ) {
                window.location.reload( false );
            } else {
                dpppUpdatePluginGroupsContent( 'hide-show-plugins', '' );
            }

        } else {
            if ( 'execute-export-rules' === globalAction ) {
                jQuery( '#dppp-results' ).html( response );

                // The button to close the box was clicked
                jQuery( '#dppp-button-close-export-rules' ).click( function(){
                    jQuery( '#dppp-results' ).html( '' );
                    jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
                });

            } else if ( 'execute-import-rules' === globalAction ) {

                if ( response.substr( 0, 12 ) !== 'dppp-timeout' ) {
                    jQuery( '#dppp-results' ).html( response );

                    // The button to close the box was clicked
                    jQuery( '#dppp-button-close-import-rules' ).click( function(){
                        jQuery( '#dppp-results' ).html( '' );
                        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
                    });

                    // The button to close the box and reload the page was clicked
                    jQuery( '#dppp-button-close-import-rules-reload' ).click( function(){
                        jQuery( '#dppp-results' ).html( '' );
                        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
                        window.location.reload( false );
                    });
                }

            } else {
                alert( dpppLocalizedOptions.errorResponse );
            }
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        window.location.reload( false );
    });
}

/*
 * When adding a new rule, filters the pages by WPML language code
 * @param {String} languageCode
 */
function dpppFilterPagesByLanguageWPML( languageCode ) {
    'use strict';
    if ( 'dppp-all' === languageCode ) {
        jQuery( '.dppp-pages-language' ).removeClass( 'dppp-display-none' );
        jQuery( '.dppp-wpml-filter-pages-active' ).addClass( 'dppp-display-none' );
        jQuery( '.dppp-wpml-filter-pages' ).removeClass( 'dppp-display-none' );
        jQuery( '#dppp-wpml-filter-pages-all' ).addClass( 'dppp-display-none' );
        jQuery( '#dppp-wpml-filter-pages-all-active' ).removeClass( 'dppp-display-none' );
    } else {
        jQuery( '.dppp-pages-language' ).addClass( 'dppp-display-none' );
        jQuery( '.dppp-wpml-filter-pages-active' ).addClass( 'dppp-display-none' );
        jQuery( '.dppp-wpml-filter-pages' ).removeClass( 'dppp-display-none' );
        jQuery( '#dppp-pages-language-' + languageCode ).removeClass( 'dppp-display-none' );
        jQuery( '#dppp-wpml-filter-pages-' + languageCode ).addClass( 'dppp-display-none' );
        jQuery( '#dppp-wpml-filter-pages-' + languageCode + '-active' ).removeClass( 'dppp-display-none' );
    }
}

/*
 * Adds two new fields in the form to be used for additional custom conditions
 * @param {String} currentNumber
 */
function dpppAddMoreConditions( currentNumber ) {
    'use strict';
    var templateHTML;
    templateHTML = jQuery( '#dppp-uri-condition-template' ).html();
    templateHTML = templateHTML.replace( 'dppp-template', 'dppp-' + currentNumber );
    templateHTML = templateHTML.replace( 'dppp-template', 'dppp-' + currentNumber );
    templateHTML = templateHTML.replace( 'dppp-template', 'dppp-' + currentNumber );
    templateHTML = templateHTML.replace( 'dppp-template', 'dppp-' + currentNumber );
    templateHTML = templateHTML.replace( 'dppp-template', 'dppp-' + currentNumber );
    templateHTML = templateHTML.replace( 'dppp-number-condition', currentNumber );
    jQuery( '#dppp-more-uri-conditions' ).append( templateHTML );
    jQuery( '#dppp-more-uri-conditions' ).removeClass( 'dppp-display-none' );
    currentNumber++;
    jQuery( '#dppp-add-more-conditions-link' ).attr( 'onclick', 'dpppAddMoreConditions( ' + currentNumber + ' )' );
}

/*
 * Removes the form fields for an additional custom condition
 * @param {String} currentNumber
 */
function dpppRemoveCondition( currentNumber ) {
    'use strict';
    jQuery( '#dppp-' + currentNumber + '-uri-condition-container' ).remove();
}

/*
 * Makes an ajax request to generate and show the form for editing an existing rule. Also handles the form changes and button click.
 * @param {Number} ruleID
 * @param {String} uriType
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 */
function dpppEditRule( ruleID, uriType, pluginFile, pluginOrGroupHash ) {
    'use strict';
    var data, saveHref;
    saveHref = jQuery( '#dppp-edit-rule-' + ruleID ).attr( 'href' );
    jQuery( '#dppp-edit-rule-' + ruleID ).attr( 'href', '#' );
    jQuery( '#dppp-edit-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-edit' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_edit_rule_action',
        'rule_id': ruleID,
        'security': dpppLocalizedOptions.ajaxNonce
    };

        // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        var id, parts, pageID, selectedPages = '';
        response = response.trim();
        jQuery( '#dppp-results' ).html( response );
        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'block' );
        jQuery( '#dppp-edit-rule-' + ruleID ).attr( 'href', saveHref );
        jQuery( '#dppp-edit-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-edit' );

        // We set the selected pages to their initial value, since we only update them on change
        selectedPages = jQuery( '#dppp-edit-rule-initial-pages' ).val() + ',';

        dpppCountSelectedPages( selectedPages );

        // A checkbox selecting a page was checked/unchecked
        jQuery( '.dppp-page-checkbox' ).change( function() {
            id = jQuery( this ).attr( 'id' );
            parts = id.split( '-' );
            pageID = parts[3];
            if ( this.checked ) {
                selectedPages += pageID + ',';
                jQuery( '#dppp-page-paragraph-' + pageID ).addClass( 'dppp-selected-element' );
            } else {
                selectedPages = selectedPages.replace( pageID + ',', '' );
                jQuery( '#dppp-page-paragraph-' + pageID ).removeClass( 'dppp-selected-element' );
            }
            dpppCountSelectedPages( selectedPages );
        });

        // The button to save the rule was clicked
        jQuery( '#dppp-button-save-rule' ).click( function(){
            dpppSaveEditRuleData( ruleID, pluginFile, pluginOrGroupHash, uriType, selectedPages );
        });

        // The button to close the box was clicked
        jQuery( '#dppp-button-close-edit-rule' ).click( function(){
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
        });

        // The affected devices dropdown menu was changed, so we may show a notice
        jQuery( '#dppp-select-devices' ).change( function() {
            if ( jQuery( this ).val() !== 'all' ) {
                jQuery( '#dppp-notice-devices' ).removeClass( 'dppp-display-none' );
                jQuery( '#dppp-read-more-devices' ).addClass( 'dppp-display-none' );
            } else {
                jQuery( '#dppp-notice-devices' ).addClass( 'dppp-display-none' );
                jQuery( '#dppp-read-more-devices' ).removeClass( 'dppp-display-none' );
            }
        });
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-edit-rule-' + ruleID ).attr( 'href', saveHref );
        jQuery( '#dppp-edit-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-edit' );
    });
}

/*
 * Makes an ajax request to save the data for the rule we are editing.
 * @param {Number} ruleID
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 * @param {String} uriType
 * @param {String} pages
 */
function dpppSaveEditRuleData( ruleID, pluginFile, pluginOrGroupHash, uriType, pages ) {
    'use strict';
    var saveButtonValue, data, deactivationType, customCondition, customValue, devices, selectTranslatedPagesWPML, loop, moreCustomConditions,
        moreCustomValues, addConditionsOnclick, maxNumberCondition, note, customFunction;

    // We disable the button and show a loading message
    jQuery( '#dppp-button-save-rule' ).prop( 'disabled', true );
    saveButtonValue = jQuery( '#dppp-button-save-rule' ).attr( 'value' );
    jQuery( '#dppp-button-save-rule' ).attr( 'value', dpppLocalizedOptions.loading );

    // We get the form data
    deactivationType = jQuery( '#dppp-select-deactivation-type' ).val();
    if ( 'custom' === uriType ) {
        customCondition = jQuery( '#dppp-custom-uri-select-condition' ).val();
        customValue = jQuery( '#dppp-custom-uri-value' ).val();
    } else {
        customCondition = '';
        customValue = '';
    }
    devices = jQuery( '#dppp-select-devices' ).val();
    note = jQuery( '#dppp-rule-note' ).val();
    customFunction = jQuery( '#dppp-custom-condition-function' ).val();
    selectTranslatedPagesWPML = 'no';
    if ( jQuery( '#dppp-select-wpml-translated-pages' ).length > 0 ) {
        if ( jQuery( '#dppp-select-wpml-translated-pages' ).is( ':checked' ) ) {
            selectTranslatedPagesWPML = 'yes';
        }
    }

    // Time to get the additional custom conditions if any
    moreCustomConditions = '';
    moreCustomValues = '';
    if ( 'custom' === uriType ) {
        addConditionsOnclick = jQuery( '#dppp-add-more-conditions-link' ).attr( 'onclick' );
        if ( addConditionsOnclick !== 'dpppAddMoreConditions( 2 )' ) {
            maxNumberCondition = addConditionsOnclick.replace( 'dpppAddMoreConditions( ', '' );
            maxNumberCondition = parseInt( maxNumberCondition.replace( ' )', '' ) );
            for ( loop = 2; loop < maxNumberCondition; loop++ ) {
                if ( jQuery( '#dppp-' + loop + '-uri-condition-container' ).length > 0 ) {
                    moreCustomConditions += '--dppp-or--' + jQuery( '#dppp-' + loop + '-custom-uri-select-condition' ).val();
                    moreCustomValues += '--dppp-or--' + jQuery( '#dppp-' + loop + '-custom-uri-value' ).val();
                }
            }
        }
    }

    data = {
        'action': 'dppp_save_edit_rule_data_action',
        'pages': pages,
        'rule_id': ruleID,
        'deactivation_type': deactivationType,
        'plugin_file': pluginFile,
        'hash': pluginOrGroupHash,
        'uri_type': uriType,
        'custom_condition': customCondition,
        'custom_value': customValue,
        'more_custom_conditions': moreCustomConditions,
        'more_custom_values': moreCustomValues,
        'devices': devices,
        'note': note,
        'custom_function': customFunction,
        'select_translated_pages_wpml': selectTranslatedPagesWPML,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {
        response = response.trim();
        jQuery( '#dppp-button-save-rule' ).prop( 'disabled', false );
        jQuery( '#dppp-button-save-rule' ).attr( 'value', saveButtonValue );
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'invalid-data' === response ) {
            alert( dpppLocalizedOptions.errorData );
        } else if ( 'select-page' === response ) {
            alert( dpppLocalizedOptions.errorSelectPage );
        } else if ( 'enter-uri' === response ) {
            alert( dpppLocalizedOptions.errorEnterURI );
        } else if ( 'could-not-check-if-exists' === response ) {
            alert( dpppLocalizedOptions.errorCheckExists );
        } else if ( 'group-does-not-exist' === response ) {
            alert( dpppLocalizedOptions.errorGroupNotExist );
        } else if ( 'already-exists' === response ) {
            alert( dpppLocalizedOptions.errorExists );
        } else if ( 'invalid-regex' === response ) {
            alert( dpppLocalizedOptions.errorRegex );
        } else if ( 'uri-not-url' === response ) {
            alert( dpppLocalizedOptions.errorURL );
        } else if ( 'could-not-edit' === response ) {
            alert( dpppLocalizedOptions.errorEdit );
        } else if ( response.substr( 0, 6 ) === '[done]' ) {
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
            jQuery( '#dppp-edit-rule-' + ruleID ).attr( 'href', '#' );
            jQuery( '#dppp-edit-rule-' + ruleID + ' .dashicons' ).removeClass( 'dashicons-edit' ).addClass( 'dashicons-update' );
            dpppUpdateRulesContent( pluginFile, pluginOrGroupHash, 'edit', '', ruleID.toString() );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-button-save-rule' ).prop( 'disabled', false );
        jQuery( '#dppp-button-save-rule' ).attr( 'value', saveButtonValue );
    });
}

/*
 * Shows the form to edit a plugin group
 * @param {String} groupHash
 */
function dpppEditPluginGroup( groupHash ) {
    'use strict';
    var data, saveHref;
    saveHref = jQuery( '#dppp-edit-group-link-' + groupHash ).attr( 'href' );
    jQuery( '#dppp-edit-group-link-' + groupHash ).attr( 'href', '#' );
    jQuery( '#dppp-edit-group-link-' + groupHash + ' .dashicons' ).removeClass( 'dashicons-edit' ).addClass( 'dashicons-update' );
    data = {
        'action': 'dppp_edit_plugin_group_action',
        'group_hash': groupHash,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        var id, parts, pluginHash, selectedPlugins = '';
        response = response.trim();
        jQuery( '#dppp-results' ).html( response );
        jQuery( '#dppp-ajax-results-container' ).css( 'display', 'block' );
        jQuery( '#dppp-edit-group-link-' + groupHash ).attr( 'href', saveHref );
        jQuery( '#dppp-edit-group-link-' + groupHash + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-edit' );

        // We set the selected plugins to their initial value, since we only update them on change
        selectedPlugins = jQuery( '#dppp-edit-group-initial-plugin-hashes' ).val();

        dpppCountSelectedPlugins( selectedPlugins );

        // A checkbox selecting a plugin was checked/unchecked
        jQuery( '.dppp-plugin-checkbox' ).change( function() {
            id = jQuery( this ).attr( 'id' );
            parts = id.split( '-' );
            pluginHash = parts[3];
            if ( this.checked ) {
                selectedPlugins += pluginHash + '_';
                jQuery( '#dppp-plugin-paragraph-' + pluginHash ).addClass( 'dppp-selected-element' );
            } else {
                selectedPlugins = selectedPlugins.replace( pluginHash + '_', '' );
                jQuery( '#dppp-plugin-paragraph-' + pluginHash ).removeClass( 'dppp-selected-element' );
            }
            dpppCountSelectedPlugins( selectedPlugins );
        });

        // The button to save the group was clicked
        jQuery( '#dppp-button-save-selected-plugins' ).click( function(){
            dpppSaveEditPluginGroupData( groupHash, selectedPlugins );
        });

        // The button to close the box was clicked
        jQuery( '#dppp-button-close-edit' ).click( function(){
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
        });
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-edit-group-link-' + groupHash ).attr( 'href', saveHref );
        jQuery( '#dppp-edit-group-link-' + groupHash + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-edit' );
    });
}

/*
 * Makes an ajax request to save the data for the plugin group we are editing.
 * @param {String} groupHash
 * @param {String} plugins
 */
function dpppSaveEditPluginGroupData( groupHash, plugins ) {
    'use strict';
    var saveButtonValue, data, groupName;

    // We disable the button and show a loading message
    jQuery( '#dppp-button-save-selected-plugins' ).prop( 'disabled', true );
    saveButtonValue = jQuery( '#dppp-button-save-selected-plugins' ).attr( 'value' );
    jQuery( '#dppp-button-save-selected-plugins' ).attr( 'value', dpppLocalizedOptions.loading );

    groupName = jQuery( '#dppp-plugin-group-name' ).val();
    data = {
        'action': 'dppp_save_edit_plugin_group_data_action',
        'group_hash': groupHash,
        'plugins': plugins,
        'group_name': groupName,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {
        response = response.trim();
        jQuery( '#dppp-button-save-selected-plugins' ).prop( 'disabled', false );
        jQuery( '#dppp-button-save-selected-plugins' ).attr( 'value', saveButtonValue );
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'already-exists-group' === response ) {
            alert( dpppLocalizedOptions.errorExistsGroup );
        } else if ( 'at-least-two-plugins' === response ) {
            alert( dpppLocalizedOptions.errorAtLeastTwoPlugins );
        } else if ( 'invalid-data' === response ) {
            alert( dpppLocalizedOptions.errorData );
        } else if ( 'could-not-edit-group' === response ) {
            alert( dpppLocalizedOptions.errorEditGroup );
        } else if ( response.substr( 0, 6 ) === '[done]' ) {
            jQuery( '#dppp-results' ).html( '' );
            jQuery( '#dppp-ajax-results-container' ).css( 'display', 'none' );
            jQuery( '#dppp-edit-group-link-' + groupHash ).attr( 'href', '#' );
            jQuery( '#dppp-edit-group-link-' + groupHash + ' .dashicons' ).removeClass( 'dashicons-edit' ).addClass( 'dashicons-update' );
            dpppUpdatePluginGroupsContent( 'edit', '' );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-button-save-selected-plugins' ).prop( 'disabled', false );
        jQuery( '#dppp-button-save-selected-plugins' ).attr( 'value', saveButtonValue );
    });
}

/*
 * Makes an ajax request to show or hide a section in the admin page
 * @param {String} section
 */
function dpppShowHideSection( section ) {
    'use strict';
    var data, saveHref, showingOrHiding, loopTimeout;
    saveHref = jQuery( '#dppp-show-hide-' + section ).attr( 'href' );
    jQuery( '#dppp-show-hide-' + section ).attr( 'href', '#' );

    if ( jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).hasClass( 'dashicons-arrow-up-alt2' ) ) {
        jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).removeClass( 'dashicons-arrow-up-alt2' ).addClass( 'dashicons-update' );
        showingOrHiding = 'hiding';
    } else {
        jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).removeClass( 'dashicons-arrow-down-alt2' ).addClass( 'dashicons-update' );
        showingOrHiding = 'showing';
    }

    if ( 'settings' !== section ) {

        // We will slowly hide/show all the plugins one by one with a timeout
        loopTimeout = 15;
        jQuery( '#dppp-' + section + '-section .dppp-inner-box' ).each( function() {
            var saveThis = this;
            setTimeout( function() {
                jQuery( saveThis ).toggleClass( 'dppp-display-none' );
            }, loopTimeout );
            loopTimeout += 15;
        });

    } else {

        // We will slowly hide/show all the settings inner sections one by one with a timeout
        loopTimeout = 15;
        if ( 'showing' === showingOrHiding ) {
            setTimeout( function() {
                jQuery( '#dppp-settings-inner' ).toggleClass( 'dppp-display-none' );
            }, loopTimeout );
            loopTimeout += 15;
        }
        jQuery( '.dppp-inner-settings-section' ).each( function() {
            var saveThis = this;
            setTimeout( function() {
                jQuery( saveThis ).toggleClass( 'dppp-display-none' );
            }, loopTimeout );
            loopTimeout += 15;
        });
        if ( 'hiding' === showingOrHiding ) {
            setTimeout( function() {
                jQuery( '#dppp-settings-inner' ).toggleClass( 'dppp-display-none' );
            }, loopTimeout );
        }
    }

    data = {
        'action': 'dppp_show_hide_section_action',
        'section': section,
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        var hasError = 'yes';
        response = response.trim();
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'done' === response ) {
            hasError = 'no';
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
        jQuery( '#dppp-show-hide-' + section ).attr( 'href', saveHref );
        if ( 'no' === hasError ) {
            if ( 'hiding' === showingOrHiding ) {
                jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-arrow-down-alt2' );
            } else {
                jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-arrow-up-alt2' );
            }
        } else {
            if ( 'hiding' === showingOrHiding ) {
                jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-arrow-up-alt2' );
            } else {
                jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-arrow-down-alt2' );
            }
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        if ( 'hiding' === showingOrHiding ) {
            jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-arrow-up-alt2' );
        } else {
            jQuery( '#dppp-show-hide-' + section + ' .dashicons' ).removeClass( 'dashicons-update' ).addClass( 'dashicons-arrow-down-alt2' );
        }
    });
}

// Constantly repositions the find pages field as we scroll
function dpppPositionFindSelectables() {
    'use strict';
    jQuery('.dppp-find-selectables').css( 'top', ( jQuery('.dppp-choose-elements').scrollTop() + 1 ) + 'px' );
}

// Filters the list of elements (like page names with checkboxes) by name when something is entered in a text field to quickly find them.
function dpppFindSelectables() {
    'use strict';
    var id, selectableName, toFind, groupPluginNames, foundInGroupPlugins;
    toFind = jQuery( '.dppp-input-find-selectables' ).val().toLowerCase();
    jQuery( '.dppp-page-paragraphs' ).each( function( positionInner, objectInner ) {
        id = jQuery( objectInner ).attr( 'id' );
        if ( jQuery( '#' + id + ' .dppp-page-title' ).length > 0 ) {
            selectableName = jQuery( '#' + id + ' .dppp-page-title' ).html().toLowerCase();
            if ( selectableName.indexOf( toFind ) > -1 ) {
                jQuery( objectInner ).css( 'display', 'block' );
            } else {
                jQuery( objectInner ).css( 'display', 'none' );
            }
        }
    });

    // We decide whether to show the icon with link that clears the text field
    if ( toFind !== '' ) {
        if ( jQuery( '#dppp-clear-find-selectables' ).hasClass( 'dppp-display-none' ) ) {
            jQuery( '#dppp-clear-find-selectables' ).removeClass( 'dppp-display-none' );
        }
    } else {
        if ( ! jQuery( '#dppp-clear-find-selectables' ).hasClass( 'dppp-display-none' ) ) {
            jQuery( '#dppp-clear-find-selectables' ).addClass( 'dppp-display-none' );
        }
    }
}

// Clears the text field for finding elements (like page names with checkboxes) and shows all of them
function dpppClearFindSelectables() {
    'use strict';
    jQuery( '.dppp-input-find-selectables' ).val( '' );
    dpppFindSelectables();
}

/*
 * Performs plugin actions (delete rules, pause rules, start rules, front-end activate/deactivate, back-end activate/deactivate)
 * @param {String} pluginAction
 * @param {String} pluginFile
 * @param {String} pluginHash
 */
function dpppPluginAction( pluginAction, pluginFile, pluginHash ) {
    'use strict';
    var data, confirmAction, saveHref;

    // We ask for a different confirmation based on the action performed (for some no confirmation is needed)
    if ( 'delete-rules' === pluginAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmDeletePluginRules );
    } else if ( 'pause-rules' === pluginAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmPausePluginRules );
    } else if ( 'start-rules' === pluginAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmStartPluginRules );
    } else if ( 'front-end-deactivate' === pluginAction || 'back-end-deactivate' === pluginAction ||
        'front-end-activate' === pluginAction || 'back-end-activate' === pluginAction ) {
        confirmAction = true;
    } else {
        alert( dpppLocalizedOptions.errorData );
        return;
    }
    if ( true !== confirmAction ) {
        return;
    }

    saveHref = jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash ).attr( 'href' );
    jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash ).attr( 'href', '#' );

    // We change the correct icon to indicate loading based on the action
    if ( 'delete-rules' === pluginAction ) {
        jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash + ' .dashicons' ).removeClass( 'dashicons-no' ).addClass( 'dashicons-update' );
    } else if ( 'pause-rules' === pluginAction ) {
        jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
            ' .dashicons' ).removeClass( 'dashicons-controls-pause' ).addClass( 'dashicons-update' );
    } else if ( 'start-rules' === pluginAction ) {
        jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
            ' .dashicons' ).removeClass( 'dashicons-controls-play' ).addClass( 'dashicons-update' );
    } else if ( 'front-end-deactivate' === pluginAction || 'front-end-activate' === pluginAction ) {
        jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
            ' .dashicons' ).removeClass( 'dashicons-welcome-view-site' ).addClass( 'dashicons-update' );
    } else if ( 'back-end-deactivate' === pluginAction || 'back-end-activate' === pluginAction ) {
        jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
            ' .dashicons' ).removeClass( 'dashicons-welcome-widgets-menus' ).addClass( 'dashicons-update' );
    }

    data = {
        'action': 'dppp_plugin_or_group_actions_action',
        'plugin_action': pluginAction,
        'plugin_file': pluginFile,
        'plugin_or_group': 'plugin',
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {

        response = response.trim();
        jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash ).attr( 'href', saveHref );

        // Remove the loading icon and return the original one
        if ( 'delete-rules' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-no' ).removeClass( 'dashicons-update' );
        } else if ( 'pause-rules' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-controls-pause' ).removeClass( 'dashicons-update' );
        } else if ( 'start-rules' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-controls-play' ).removeClass( 'dashicons-update' );
        } else if ( 'front-end-deactivate' === pluginAction || 'front-end-activate' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-welcome-view-site' ).removeClass( 'dashicons-update' );
        } else if ( 'back-end-deactivate' === pluginAction || 'back-end-activate' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-welcome-widgets-menus' ).removeClass( 'dashicons-update' );
        }

        // Show an error if needed
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'invalid-data' === response ) {
            alert( dpppLocalizedOptions.errorData );

        // Success
        } else if ( response.substr( 0, 6 ) === '[done]' ) {
            dpppUpdateRulesContent( pluginFile, pluginHash, '', '', '' );
            if ( 'front-end-deactivate' === pluginAction ) {
                jQuery( '#dppp-inner-box-' + pluginHash ).addClass( 'dppp-front-end-deactivated' );
            } else if ( 'back-end-deactivate' === pluginAction ) {
                jQuery( '#dppp-inner-box-' + pluginHash ).addClass( 'dppp-back-end-deactivated' );
            } else if ( 'front-end-activate' === pluginAction ) {
                jQuery( '#dppp-inner-box-' + pluginHash ).removeClass( 'dppp-front-end-deactivated' );
            } else if ( 'back-end-activate' === pluginAction ) {
                jQuery( '#dppp-inner-box-' + pluginHash ).removeClass( 'dppp-back-end-deactivated' );
            } else if ( 'delete-rules' === pluginAction ) {
                jQuery( '#dppp-inner-box-' + pluginHash + ' .dppp-plugin-or-group-start-rules-link' ).addClass( 'dppp-display-none' );
                jQuery( '#dppp-inner-box-' + pluginHash + ' .dppp-plugin-or-group-pause-rules-link' ).addClass( 'dppp-display-none' );
                jQuery( '#dppp-inner-box-' + pluginHash + ' .dppp-plugin-or-group-delete-rules-link' ).addClass( 'dppp-display-none' );
            }
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash ).attr( 'href', saveHref );

        // Remove the loading icon and return the original one
        if ( 'delete-rules' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-no' ).removeClass( 'dashicons-update' );
        } else if ( 'pause-rules' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-controls-pause' ).removeClass( 'dashicons-update' );
        } else if ( 'start-rules' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-controls-play' ).removeClass( 'dashicons-update' );
        } else if ( 'front-end-deactivate' === pluginAction || 'front-end-activate' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-welcome-view-site' ).removeClass( 'dashicons-update' );
        } else if ( 'back-end-deactivate' === pluginAction || 'back-end-activate' === pluginAction ) {
            jQuery( '#dppp-plugin-or-group-' + pluginAction + '-link-' + pluginHash +
                ' .dashicons' ).addClass( 'dashicons-welcome-widgets-menus' ).removeClass( 'dashicons-update' );
        }
    });
}

/*
 * Performs group actions (delete rules, pause rules, start rules, front-end activate/deactivate, back-end activate/deactivate)
 * @param {String} groupAction
 * @param {String} groupHash
 */
function dpppGroupAction( groupAction, groupHash ) {
    'use strict';
    var data, confirmAction, saveHref;

    // We ask for a different confirmation based on the action performed (for some no confirmation is needed)
    if ( 'delete-rules' === groupAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmDeleteGroupRules );
    } else if ( 'pause-rules' === groupAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmPauseGroupRules );
    } else if ( 'start-rules' === groupAction ) {
        confirmAction = confirm( dpppLocalizedOptions.confirmStartGroupRules );
    } else if ( 'front-end-deactivate' === groupAction || 'back-end-deactivate' === groupAction ||
        'front-end-activate' === groupAction || 'back-end-activate' === groupAction ) {
        confirmAction = true;
    } else {
        alert( dpppLocalizedOptions.errorData );
        return;
    }
    if ( true !== confirmAction ) {
        return;
    }

    saveHref = jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash ).attr( 'href' );
    jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash ).attr( 'href', '#' );

    // We change the correct icon to indicate loading based on the action
    if ( 'delete-rules' === groupAction ) {
        jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash + ' .dashicons' ).removeClass( 'dashicons-no' ).addClass( 'dashicons-update' );
    } else if ( 'pause-rules' === groupAction ) {
        jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
            ' .dashicons' ).removeClass( 'dashicons-controls-pause' ).addClass( 'dashicons-update' );
    } else if ( 'start-rules' === groupAction ) {
        jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
            ' .dashicons' ).removeClass( 'dashicons-controls-play' ).addClass( 'dashicons-update' );
    } else if ( 'front-end-deactivate' === groupAction || 'front-end-activate' === groupAction ) {
        jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
            ' .dashicons' ).removeClass( 'dashicons-welcome-view-site' ).addClass( 'dashicons-update' );
    } else if ( 'back-end-deactivate' === groupAction || 'back-end-activate' === groupAction ) {
        jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
            ' .dashicons' ).removeClass( 'dashicons-welcome-widgets-menus' ).addClass( 'dashicons-update' );
    }

    data = {
        'action': 'dppp_plugin_or_group_actions_action',
        'plugin_action': groupAction,
        'group_hash': groupHash,
        'plugin_or_group': 'group',
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function ( response ) {

        response = response.trim();
        jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash ).attr( 'href', saveHref );

        // Remove the loading icon and return the original one
        if ( 'delete-rules' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-no' ).removeClass( 'dashicons-update' );
        } else if ( 'pause-rules' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-controls-pause' ).removeClass( 'dashicons-update' );
        } else if ( 'start-rules' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-controls-play' ).removeClass( 'dashicons-update' );
        } else if ( 'front-end-deactivate' === groupAction || 'front-end-activate' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-welcome-view-site' ).removeClass( 'dashicons-update' );
        } else if ( 'back-end-deactivate' === groupAction || 'back-end-activate' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-welcome-widgets-menus' ).removeClass( 'dashicons-update' );
        }

        // Show an error if needed
        if ( 'no-access' === response ) {
            alert( dpppLocalizedOptions.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedOptions.errorNonce );
        } else if ( 'group-does-not-exist' === response ) {
            alert( dpppLocalizedOptions.errorGroupNotExist );
        } else if ( 'invalid-data' === response ) {
            alert( dpppLocalizedOptions.errorData );

        // Success
        } else if ( response.substr( 0, 6 ) === '[done]' ) {
            dpppUpdateRulesContent( 'dppp-group', groupHash, '', '', '' );
            if ( 'front-end-deactivate' === groupAction ) {
                jQuery( '#dppp-inner-box-' + groupHash ).addClass( 'dppp-front-end-deactivated' );
            } else if ( 'back-end-deactivate' === groupAction ) {
                jQuery( '#dppp-inner-box-' + groupHash ).addClass( 'dppp-back-end-deactivated' );
            } else if ( 'front-end-activate' === groupAction ) {
                jQuery( '#dppp-inner-box-' + groupHash ).removeClass( 'dppp-front-end-deactivated' );
            } else if ( 'back-end-activate' === groupAction ) {
                jQuery( '#dppp-inner-box-' + groupHash ).removeClass( 'dppp-back-end-deactivated' );
            } else if ( 'delete-rules' === groupAction ) {
                jQuery( '#dppp-inner-box-' + groupHash + ' .dppp-plugin-or-group-start-rules-link' ).addClass( 'dppp-display-none' );
                jQuery( '#dppp-inner-box-' + groupHash + ' .dppp-plugin-or-group-pause-rules-link' ).addClass( 'dppp-display-none' );
                jQuery( '#dppp-inner-box-' + groupHash + ' .dppp-plugin-or-group-delete-rules-link' ).addClass( 'dppp-display-none' );
            }
        } else {
            alert( dpppLocalizedOptions.errorResponse );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash ).attr( 'href', saveHref );

        // Remove the loading icon and return the original one
        if ( 'delete-rules' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-no' ).removeClass( 'dashicons-update' );
        } else if ( 'pause-rules' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-controls-pause' ).removeClass( 'dashicons-update' );
        } else if ( 'start-rules' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-controls-play' ).removeClass( 'dashicons-update' );
        } else if ( 'front-end-deactivate' === groupAction || 'front-end-activate' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-welcome-view-site' ).removeClass( 'dashicons-update' );
        } else if ( 'back-end-deactivate' === groupAction || 'back-end-activate' === groupAction ) {
            jQuery( '#dppp-plugin-or-group-' + groupAction + '-link-' + groupHash +
                ' .dashicons' ).addClass( 'dashicons-welcome-widgets-menus' ).removeClass( 'dashicons-update' );
        }
    });
}

// Selects all the text in the text box with exported rules and settings
function dpppSelectAllExported() {
    'use strict';
    jQuery( '#dppp-export-textarea' ).select();
}

// Gets the address of the plugin icon and inserts the image icon HTML code on the page
function dpppGetPluginIcon() {
    'use strict';
    var data, pluginSlug, pluginFile, elementID;

    // We proceed only if there are any plugin icon containers for plugins that we have not checked yet what is the icon address
    if ( jQuery( '.dppp-plugin-icon.dppp-not-set' ).length > 0 ) {

        // The ID of the first element that will contain the plugin icon image and we haven't set the icon image address for
        elementID = jQuery( '.dppp-plugin-icon.dppp-not-set' ).first().attr( 'id' );
        pluginSlug = jQuery( '#' + elementID ).attr( 'data-plugin-slug' );
        pluginFile = jQuery( '#' + elementID ).attr( 'data-plugin-file' );

        data = {
            'action': 'dppp_get_plugin_icon_action',
            'plugin_slug': pluginSlug,
            'plugin_file': pluginFile,
            'security': dpppLocalizedOptions.ajaxNonce
        };

        // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
        jQuery.post( ajaxurl, data, function ( response ) {
            var pluginIconURL;

            response = response.trim();

            // If the request was successfull we add the plugin icon image next to the name and schedule the next execution of the function in half a second
            if ( response.substr( 0, 6 ) === '[done]' ) {
                pluginIconURL = response.replace( '[done]', '' );
                if ( pluginIconURL !== 'not-found' ) {
                    jQuery( '#' + elementID ).html( '<img src="' + pluginIconURL + '" />' );
                }
                jQuery( '#' + elementID ).removeClass( 'dppp-not-set' );
                setTimeout( dpppGetPluginIcon, 500 );
            }
        }).fail( function() {
            alert( dpppLocalizedOptions.errorServerFail );
        });

    // The icon images that had an error loading will have their plugin icon fetched again and loaded (usually when the plugin chnages their icon)
    } else if ( jQuery( '.dppp-error-img' ).length > 0 ) {
        jQuery( '.dppp-error-img' ).each( function( i, obj ) {
            jQuery( this ).parent().addClass( 'dppp-not-set' );
            jQuery( this ).removeClass( 'dppp-error-img' );
        });
        setTimeout( dpppGetPluginIcon, 500 );
    }
}

// Makes an ajax request that creates a cookie on this device to make it local for local mode
function dpppMakeDeviceLocal() {
    'use strict';
    var data, saveHTML, confirmAction;

    confirmAction = confirm( dpppLocalizedOptions.confirmLocalDevice );
    if ( true !== confirmAction ) {
        return;
    }

    saveHTML = jQuery( '#dppp-link-local-mode' ).html();
    jQuery( '#dppp-link-local-mode' ).html( dpppLocalizedOptions.loading );

    data = {
        'action': 'dppp_make_device_local_action',
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        if ( 'no-access' === response.trim() ) {
            alert( dpppLocalizedOptions.errorAccess );
            jQuery( '#dppp-link-local-mode' ).html( saveHTML );
        } else if ( 'invalid-nonce' === response.trim() ) {
            alert( dpppLocalizedOptions.errorNonce );
            jQuery( '#dppp-link-local-mode' ).html( saveHTML );
        } else if ( 'failed-cookie' === response.trim() ) {
            alert( dpppLocalizedOptions.errorSetCookie );
            jQuery( '#dppp-link-local-mode' ).html( saveHTML );
        } else if ( '[done]' === response.trim() ) {
            window.location.reload( false );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
            jQuery( '#dppp-link-local-mode' ).html( saveHTML );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-link-local-mode' ).html( saveHTML );
    });
}

// Makes an ajax request that removes the cookie on this device to remove it from local mode
function dpppRemoveLocalDevice() {
    'use strict';
    var data, saveHTML;

    saveHTML = jQuery( '#dppp-link-local-mode' ).html();
    jQuery( '#dppp-link-local-mode' ).html( dpppLocalizedOptions.loading );

    data = {
        'action': 'dppp_remove_local_device_action',
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        if ( 'no-access' === response.trim() ) {
            alert( dpppLocalizedOptions.errorAccess );
            jQuery( '#dppp-link-local-mode' ).html( saveHTML );
        } else if ( 'invalid-nonce' === response.trim() ) {
            alert( dpppLocalizedOptions.errorNonce );
            jQuery( '#dppp-link-local-mode' ).html( saveHTML );
        } else if ( 'failed-remove-cookie' === response.trim() ) {
            alert( dpppLocalizedOptions.errorRemoveCookie );
            jQuery( '#dppp-link-local-mode' ).html( saveHTML );
        } else if ( '[done]' === response.trim() ) {
            window.location.reload( false );
        } else {
            alert( dpppLocalizedOptions.errorResponse );
            jQuery( '#dppp-link-local-mode' ).html( saveHTML );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-link-local-mode' ).html( saveHTML );
    });
}

// Selects all visible pages (not hidden by the find feature) when adding a new rule
function dpppSelectAllPages() {
    'use strict';
    jQuery( '.dppp-page-checkbox' ).each( function() {
        if ( jQuery( this ).is( ':visible' ) && ! this.checked ) {
            jQuery( this ).prop( "checked", true ).triggerHandler( 'change' );
        }
    });
}

// Deselects all visible pages (not hidden by the find feature) when adding a new rule
function dpppDeselectAllPages() {
    'use strict';
    jQuery( '.dppp-page-checkbox' ).each( function() {
        if ( jQuery( this ).is( ':visible' ) && this.checked ) {
            jQuery( this ).prop( "checked", false ).triggerHandler( 'change' );
        }
    });
}

// Counts the selected pages when adding a new rule
function dpppCountSelectedPages( selectedPages ) {
    'use strict';
    jQuery( '.dppp-under-pages-links-left span' ).html( parseInt( ( selectedPages.match( /,/g ) || [] ).length ) );
}

// Selects all visible plugins when adding a new group
function dpppSelectAllPlugins() {
    'use strict';
    jQuery( '.dppp-plugin-checkbox' ).each( function() {
        if ( jQuery( this ).is( ':visible' ) && ! this.checked ) {
            jQuery( this ).prop( "checked", true ).triggerHandler( 'change' );
        }
    });
}

// Deselects all visible plugins when adding a new group
function dpppDeselectAllPlugins() {
    'use strict';
    jQuery( '.dppp-plugin-checkbox' ).each( function() {
        if ( jQuery( this ).is( ':visible' ) && this.checked ) {
            jQuery( this ).prop( "checked", false ).triggerHandler( 'change' );
        }
    });
}

// Counts the selected plugins when adding a new group
function dpppCountSelectedPlugins( selectedPlugins ) {
    'use strict';
    jQuery( '.dppp-under-plugins-links-left span' ).html( parseInt( ( selectedPlugins.match( /_/g ) || [] ).length ) );
}

// Shows a hidden element
function dpppShowHidden( elementID, hideClicked ) {
    'use strict';
    jQuery( '#' + elementID ).removeClass( 'dppp-display-none' );
    jQuery( '#' + hideClicked ).addClass( 'dppp-display-none' );
}

// Copies a rule (only selects it as one to be copied)
function dpppCopyRule( ruleID ) {
    'use strict';
    if( jQuery.inArray( ruleID, dpppCopiedRules ) === -1 ) {
        dpppCopiedRules.push( ruleID );
        jQuery( '.dppp-show-on-copy-rule, #dppp-copied-rule-' + ruleID + ', #dppp-contain-undo-copied-rule-' + ruleID ).removeClass( 'dppp-display-none' );
        jQuery( '.dppp-hide-on-copy-rule' ).addClass( 'dppp-display-none' );
        if ( dpppCopiedRules.length > 1 ) {
            jQuery( '.dppp-paste-rules' ).html( dpppLocalizedOptions.pasteRules.replace( "%d", dpppCopiedRules.length ) );
        } else if ( dpppCopiedRules.length === 1 ) {
            jQuery( '.dppp-paste-rules' ).html( dpppLocalizedOptions.pasteRule );
        } else {
            dpppCancelPasteRules();
        }
    }
}

// Uncopies a rule that has been copied (selected as one to be copied)
function dpppUndoCopyRule( ruleID ) {
    'use strict';
    var index;
    index = dpppCopiedRules.indexOf( ruleID );
    if ( index !== -1 ) {
        dpppCopiedRules.splice( index, 1 );
    }
    jQuery( '#dppp-copied-rule-' + ruleID + ', #dppp-contain-undo-copied-rule-' + ruleID ).addClass( 'dppp-display-none' );
    if ( dpppCopiedRules.length > 1 ) {
        jQuery( '.dppp-paste-rules' ).html( dpppLocalizedOptions.pasteRules.replace( "%d", dpppCopiedRules.length ) );
    } else if ( dpppCopiedRules.length === 1 ) {
        jQuery( '.dppp-paste-rules' ).html( dpppLocalizedOptions.pasteRule );
    } else {
        dpppCancelPasteRules();
    }
}

/*
 * Makes the ajax request to paste the selected rules
 * @param {String} pluginFile
 * @param {String} pluginOrGroupHash
 */
function dpppPasteRules( pluginFile, pluginOrGroupHash ) {
    'use strict';
    var data, saveHTML, saveHref;

    saveHref = jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash ).attr( 'href' );
    jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash ).removeAttr( 'href' );
    saveHTML = jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash + ' .dppp-paste-rules' ).html();
    jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash + ' .dppp-paste-rules' ).html( dpppLocalizedOptions.loading );

    jQuery( '.dppp-hide-while-pasting-rule' ).addClass( 'dppp-display-none' );
    jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash ).removeClass( 'dppp-display-none' );
    jQuery( '.dppp-contain-undo-copied-rule' ).addClass( 'dppp-invisible' ).addClass( 'dppp-unclickable' );

    data = {
        'action': 'dppp_paste_rules_action',
        'plugin_file': pluginFile,
        'hash': pluginOrGroupHash,
        'rule_ids': dpppCopiedRules.join( "," ),
        'security': dpppLocalizedOptions.ajaxNonce
    };

    // We are making the ajax request. Since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php.
    jQuery.post( ajaxurl, data, function( response ) {
        response = response.trim();
        if ( response.substr( 0, 4 ) === 'done' ) {
            if ( 'done-skipped-failed' === response ) {
                alert( dpppLocalizedOptions.donePastedRulesSkippedFailed );
            } else if ( 'done-skipped' === response ) {
                alert( dpppLocalizedOptions.donePastedRulesSkipped );
            } else if ( 'done-failed' === response ) {
                alert( dpppLocalizedOptions.donePastedRulesFailed );
            }
            window.location.reload( false );
        } else {
            if ( 'no-access' === response ) {
                alert( dpppLocalizedOptions.errorAccess );
            } else if ( 'invalid-nonce' === response ) {
                alert( dpppLocalizedOptions.errorNonce );
            } else if ( 'group-does-not-exist' === response ) {
                alert( dpppLocalizedOptions.errorGroupNotExist );
            } else if ( 'invalid-data' === response ) {
                alert( dpppLocalizedOptions.errorData );
            } else if ( 'skipped-failed' === response ) {
                alert( dpppLocalizedOptions.errorPastedRulesSkippedFailed );
            } else if ( 'skipped' === response ) {
                alert( dpppLocalizedOptions.errorPastedRulesSkipped );
            } else if ( 'failed' === response ) {
                alert( dpppLocalizedOptions.errorPastedRulesFailed );
            } else if ( 'error' === response ) {
                alert( dpppLocalizedOptions.errorPastedRulesError );
            } else {
                alert( dpppLocalizedOptions.errorResponse );
            }
            jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash ).attr( 'href', saveHref );
            jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash + ' .dppp-paste-rules' ).html( saveHTML );
            jQuery( '.dppp-hide-while-pasting-rule' ).removeClass( 'dppp-display-none' );
            jQuery( '.dppp-contain-undo-copied-rule' ).removeClass( 'dppp-invisible' ).removeClass( 'dppp-unclickable' );
        }
    }).fail( function() {
        alert( dpppLocalizedOptions.errorServerFail );
        jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash ).attr( 'href', saveHref );
        jQuery( '#dppp-paste-rules-link-' + pluginOrGroupHash + ' .dppp-paste-rules' ).html( saveHTML );
        jQuery( '.dppp-hide-while-pasting-rule' ).removeClass( 'dppp-display-none' );
        jQuery( '.dppp-contain-undo-copied-rule' ).removeClass( 'dppp-invisible' ).removeClass( 'dppp-unclickable' );
    });
}

// Cancels the process of copying rules before pasting has started
function dpppCancelPasteRules() {
    'use strict';
    dpppCopiedRules = [];
    jQuery( '.dppp-hide-on-copy-rule' ).removeClass( 'dppp-display-none' );
    jQuery( '.dppp-show-on-copy-rule, .dppp-copied-rule, .dppp-contain-undo-copied-rule' ).addClass( 'dppp-display-none' );
    jQuery( '.dppp-paste-rules' ).html( dpppLocalizedOptions.pasteRule );
}

jQuery( function() {
    'use strict';

    // When the page loads we schedule the execution of a function that will check if we need to load plugin icon images
    setTimeout( dpppGetPluginIcon, 1000 );

    // If we are on the URL that recreates the admin menu cache, we go back to the normal settings URL where global deactivation are not working
    if ( window.location.href.indexOf( 'dppp-recreate-cache=yes' ) != -1 ) {
        window.location = dpppLocalizedOptions.settingsURL;
    }
});
