
// global dpppLocalizedDebug

// Hides the debug box, squeezing it into a much smaller box
function dpppHideDebug() {
    'use strict';
    jQuery( '#dppp-hide-debug' ).removeClass( 'dashicons-arrow-down-alt2' );
    jQuery( '#dppp-hide-debug' ).addClass( 'dashicons-update' );
    jQuery( '#dppp-show-debug' ).removeClass( 'dashicons-arrow-up-alt2' );
    jQuery( '#dppp-show-debug' ).addClass( 'dashicons-update' );
    dpppSaveDebugBox( 'hidden' );
    jQuery( '#dppp-debug-box' ).css( 'overflow-y', 'hidden' );
    setTimeout( function () {
        jQuery( '#dppp-debug-content' ).css( 'display', 'none' );
        jQuery( '#dppp-show-debug' ).css( 'display', 'block' );
        jQuery( '#dppp-show-debug-logo' ).css( 'display', 'block' );
    }, 300 );
    jQuery( '#dppp-debug-box' ).css( 'width', '85px' );
    jQuery( '#dppp-debug-box' ).css( 'height', '57px' );
    jQuery( '#dppp-debug-box' ).css( 'padding', '10px' );
}

// Shows the debug box, expanding it from a smaller box to a normal sized one
function dpppShowDebug() {
    'use strict';
    jQuery( '#dppp-hide-debug' ).removeClass( 'dashicons-arrow-down-alt2' );
    jQuery( '#dppp-hide-debug' ).addClass( 'dashicons-update' );
    jQuery( '#dppp-show-debug' ).removeClass( 'dashicons-arrow-up-alt2' );
    jQuery( '#dppp-show-debug' ).addClass( 'dashicons-update' );
    dpppSaveDebugBox( 'shown' );
    jQuery( '#dppp-debug-box' ).css( 'width', '380px' );
    jQuery( '#dppp-debug-box' ).css( 'height', '450px' );
    jQuery( '#dppp-debug-box' ).css( 'padding', '18px' );
    jQuery( '#dppp-show-debug' ).css( 'display', 'none' );
    jQuery( '#dppp-show-debug-logo' ).css( 'display', 'none' );
    jQuery( '#dppp-debug-content' ).css( 'display', 'block' );
    setTimeout( function () {
        jQuery( '#dppp-debug-box' ).css( 'overflow-y', 'auto' );
    }, 500 );
}

/*
 * Makes an ajax request to save the current state of the debug box
 * @param {String} state
 */
function dpppSaveDebugBox( state ) {
    'use strict';
    var data;
    data = {
        'action': 'dppp_save_debug_box_action',
        'state': state,
        'security': dpppLocalizedDebug.ajaxNonce
    };
    jQuery.post( dpppLocalizedDebug.ajaxurl, data, function( response ) {
        jQuery( '#dppp-hide-debug' ).removeClass( 'dashicons-update' );
        jQuery( '#dppp-hide-debug' ).addClass( 'dashicons-arrow-down-alt2' );
        jQuery( '#dppp-show-debug' ).removeClass( 'dashicons-update' );
        jQuery( '#dppp-show-debug' ).addClass( 'dashicons-arrow-up-alt2' );
    });
}

/*
 * Shows and hides a hint text
 * @param {Number} id
 */
function dpppShowHideDebugHint( id ) {
    'use strict';
    if ( jQuery( '#dppp-hint-' + id ).css( 'display' ) === 'none' ) {
        jQuery( '#dppp-hint-' + id ).css( 'display', 'block' );
        jQuery( '.dppp-break-' + id ).css( 'display', 'none' );
    } else {
        jQuery( '#dppp-hint-' + id ).css( 'display', 'none' );
        jQuery( '.dppp-break-' + id ).css( 'display', 'inline' );
    }
}

/*
 * Shows the quick actions for a plugin and hides the plugin list
 * @param {String} pluginFile
 * @param {String} pluginHash
 * @param {String} pluginName
 */
function dpppDebugOpenPluginActions( pluginFile, pluginHash, pluginName ) {
    'use strict';
    jQuery( '#dppp-debug-box .dppp-plugin-list-title' ).hide();
    jQuery( '#dppp-debug-box .dppp-plugin-list' ).hide();
    jQuery( '#dppp-debug-box #dppp-plugin-actions-' + pluginHash ).removeClass( 'dppp-display-none' );
}

/*
 * Closes the quick plugin actions and shows the plugin list
 * @param {String} pluginHash
 */
function dpppDebugClosePluginActions( pluginHash ) {
    'use strict';
    jQuery( '#dppp-debug-box .dppp-plugin-list-title' ).show();
    jQuery( '#dppp-debug-box .dppp-plugin-list' ).show();
    jQuery( '#dppp-debug-box #dppp-plugin-actions-' + pluginHash ).addClass( 'dppp-display-none' );
}

// Reloads the page, when the reload icon is clicked
function dpppDebugReloadPage() {
    'use strict';
    jQuery( '.dppp-debug-reload-page span' ).removeClass( 'dashicons-image-rotate dppp-flip-character' );
    jQuery( '.dppp-debug-reload-page span' ).addClass( 'dashicons-update' );
    window.location.reload( false );
}

/*
 * Makes an ajax request to execute a quick action for a plugin
 * @param {String} quickAction
 * @param {String} pluginFile
 * @param {String} pluginHash
 */
function dpppDebugQuickAction( quickAction, pluginFile, pluginHash ) {
    'use strict';
    var data, uri, pageID, groupHash, saveClass, saveHref;

    // We save the href value of the link that is clicked to perform the action, and we change it so it is not clicked while loading
    saveHref = jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).attr( 'href' );
    jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).attr( 'href', '#' );

    // We save the class value of the icon in the link that is clicked to perform the action, and we change it so it shows a loading icon
    saveClass = jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash + ' span' ).attr( 'class' );
    jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash + ' span' ).attr( 'class', 'dashicons dashicons-update' );

    uri = jQuery( '#dppp-debug-current-uri' ).val();
    pageID = jQuery( '#dppp-debug-current-page-id' ).val();

    // If there are groups, we get the hash of the selected one
    if ( jQuery( '.dppp-debug-add-to-group' ).length > 0 ) {
        groupHash = jQuery( '#dppp-debug-select-add-to-group-' + pluginHash ).val();
    } else {
        groupHash = 'no';
    }

    data = {
        'action': 'dppp_debug_quick_action_action',
        'quick_action': quickAction,
        'plugin_file': pluginFile,
        'uri': uri,
        'page_id': pageID,
        'group_hash': groupHash,
        'security': dpppLocalizedDebug.ajaxNonce
    };

    // We make the ajax request to perform the selected action
    jQuery.post( dpppLocalizedDebug.ajaxurl, data, function( response ) {
        var id, newGroupHash;

        response = response.trim();

        // We handle the response, we show an error if needed
        if ( 'no-access' === response ) {
            alert( dpppLocalizedDebug.errorAccess );
        } else if ( 'invalid-nonce' === response ) {
            alert( dpppLocalizedDebug.errorNonce );
        } else if ( 'already-exists' === response ) {
            alert( dpppLocalizedDebug.errorExists );
        } else if ( 'could-not-insert' === response ) {
            alert( dpppLocalizedDebug.errorInsert );
        } else if ( 'no-groups' === response ) {
            alert( dpppLocalizedDebug.errorNoGroups );
        } else if ( 'group-not-exist' === response ) {
            alert( dpppLocalizedDebug.errorGroupNotExist );
        } else if ( 'already-in-group' === response ) {
            alert( dpppLocalizedDebug.errorAlreadyInGroup );
        } else if ( 'at-least-two-plugins' === response ) {
            alert( dpppLocalizedDebug.errorAtLeastTwoPlugins );
        } else if ( 'already-exists-group' === response ) {
            alert( dpppLocalizedDebug.errorExistsGroup );
        } else if ( 'could-not-edit-group' === response ) {
            alert( dpppLocalizedDebug.errorEditGroup );

        // If the response starts with [done], it means it was a success
        } else if ( response.substr( 0, 6 ) === '[done]' ) {

            // The performed action was adding a plugin to a group
            if ( 'add-to-group' === quickAction ) {

                // We display a small message that it is done and we hide the link
                jQuery( '#dppp-debug-done-add-to-group-' + pluginHash ).removeClass( 'dppp-display-none' );
                jQuery( '.dppp-debug-add-to-group-' + pluginHash ).addClass( 'dppp-display-none' );

                // If another group is selected, we show the link again and hide the message
                jQuery( '#dppp-debug-select-add-to-group-' + pluginHash ).change( function() {
                    jQuery( '#dppp-debug-done-add-to-group-' + pluginHash ).addClass( 'dppp-display-none' );
                    jQuery( '.dppp-debug-add-to-group-' + pluginHash ).removeClass( 'dppp-display-none' );
                    jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).attr( 'href', saveHref );
                });

                newGroupHash = response.substr( 6, 32 );

                // Update the old group hash to the new one in the select dropdown menus, so we can continue adding to the group without reloading the page
                jQuery( '.dppp-debug-add-to-group' ).each( function( indexSelect, objectSelect ) {
                    id = jQuery( this ).attr( 'id' );
                    jQuery( '#' + id + ' option' ).each( function( indexOption, objectOption ) {
                        if ( jQuery( this ).attr( 'value' ) === groupHash ) {
                            jQuery( this ).attr( 'value', newGroupHash );
                        }
                    });
                });

            // An action that is not adding to a group was performed, so we show a message that it is done and we make the link not clickable
            } else {
                jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).css( 'color', '#009900' );
                jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).css( 'text-decoration', 'none' );
                jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).css( 'pointer-events', 'none' );
                jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).append( ' (' + dpppLocalizedDebug.done + ')' );
                jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).attr( 'href', '#' );
            }

        // We got an unexpected response, something went wrong
        } else {
            alert( dpppLocalizedDebug.errorResponse );
        }

        // We restore the class of the icon in the link
        jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash + ' span' ).attr( 'class' , saveClass );

        // If the request was not successful we restore the href attribute of the link
        if ( response.substr( 0, 6 ) !== '[done]' ) {
            jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).attr( 'href', saveHref );
        }
    }).fail( function() {
        alert( dpppLocalizedDebug.errorServerFail );

        // We restore the class of the icon in the link
        jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash + ' span' ).attr( 'class' , saveClass );

        // We restore the href attribute of the link
        jQuery( '.dppp-debug-' + quickAction + '-' + pluginHash ).attr( 'href', saveHref );
    });
}
