<?php

/**
 * Variable Price Feature
 */
class BebanStore_Variable_Price extends BebanStore_Feature {
    /**
     * Initialize the feature
     */
    public function __construct() {
        parent::__construct(
            'variable_price',
            __('نمایش کمترین قیمت محصولات متغیر', 'bebanstore'),
            __('نمایش کمترین قیمت به جای محدوده قیمت در محصولات متغیر', 'bebanstore')
        );

        
    }

    /**
     * Register hooks
     */
    protected function register_hooks() {
        // Add filters for variable price display
        add_filter('woocommerce_variable_sale_price_html', array($this, 'modify_variable_price'), 10, 2);
        add_filter('woocommerce_variable_price_html', array($this, 'modify_variable_price'), 10, 2);
    }

    /**
     * Get feature tab
     */
    public function get_tab() {
        return 'product';
    }

    /**
     * Modify variable price display
     */
    public function modify_variable_price($price, $product) {
        // Get minimum prices
        $min_price = $product->get_variation_price('min', true);
        $min_regular_price = $product->get_variation_regular_price('min', true);

        // Format prices
        $formatted_min_price = wc_price($min_price);
        $formatted_min_regular_price = wc_price($min_regular_price);

        // If there's a sale price
        if ($min_price !== $min_regular_price) {
            $price = sprintf(
                '<del>%s</del> <ins>%s</ins>',
                $formatted_min_regular_price . $product->get_price_suffix(),
                $formatted_min_price . $product->get_price_suffix()
            );
        } else {
            $price = $formatted_min_price . $product->get_price_suffix();
        }

        return $price;
    }

    /**
     * Cleanup feature resources
     */
    public function cleanup() {
        remove_filter('woocommerce_variable_sale_price_html', array($this, 'modify_variable_price'), 10);
        remove_filter('woocommerce_variable_price_html', array($this, 'modify_variable_price'), 10);
    }
} 