<?php
/**
 * Order Count Feature
 *
 * @package BebanStore
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class BebanStore_Order_Count
 */
class BebanStore_Order_Count extends BebanStore_Shortcode_Feature {
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct(
            'order_count',
            __('شمارش سفارشات', 'bebanstore'),
            __('نمایش تعداد سفارشات کاربر در وضعیت‌های مختلف', 'bebanstore'),
            'beban_order_count',
            __('برای نمایش تعداد سفارشات از شورتکد استفاده کنید. وضعیت‌های مجاز: processing (در حال پردازش)، completed (تکمیل شده)، refunded (مسترد شده)، cancelled (لغو شده)

            مثال:
            [beban_order_count status="processing"]', 'bebanstore')
        );
    }

    /**
     * Render shortcode
     *
     * @param array  $atts    Shortcode attributes
     * @param string $content Shortcode content
     * @return string
     */
    public function render_shortcode($atts, $content = null) {
        // پیش‌فرض‌ها و استخراج ویژگی‌ها
        $atts = shortcode_atts(
            [
                'status' => 'processing', // پیش‌فرض: در حال پردازش
            ],
            $atts,
            'beban_order_count'
        );

        // پاک‌سازی ورودی status
        $status = sanitize_key($atts['status']);
        
        // وضعیت‌های معتبر ووکامرس
        $valid_statuses = [
            'processing' => 'wc-processing',
            'completed' => 'wc-completed',
            'refunded' => 'wc-refunded',
            'cancelled' => 'wc-cancelled',
        ];

        // بررسی وضعیت معتبر
        if (!array_key_exists($status, $valid_statuses)) {
            return '0'; // اگه وضعیت نامعتبر بود، 0 برگردون
        }

        // گرفتن تعداد سفارشات
        $order_count = count(wc_get_orders([
            'customer_id' => get_current_user_id(),
            'status' => $valid_statuses[$status],
            'limit' => -1, // همه سفارشات
        ]));

        // برگرداندن تعداد (عدد)
        return absint($order_count);
    }

    /**
     * Register hooks
     */
    protected function register_hooks() {
        // No additional hooks needed for this feature
    }

    /**
     * Enqueue assets
     */
    public function enqueue_assets() {
        // No additional assets needed for this feature
    }
} 