<?php
/**
 * Custom Font Feature
 *
 * @package BebanStore
 * @since 1.0.4
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Custom Font Feature Class
 *
 * Provides custom font management for BebanStore features
 */
class BebanStore_Custom_Font extends BebanStore_Feature {
    
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct(
            'custom_font',
            __('فونت سفارشی', 'bebanstore'),
            __('مدیریت فونت ایران یکان برای ویژگی‌های مختلف افزونه', 'bebanstore')
        );
    }
    
    /**
     * Initialize the feature
     */
    public function init() {
        // Initialize the feature
    }
    
    /**
     * Register hooks
     */
    protected function register_hooks() {
        if ($this->is_enabled()) {
            // Enqueue custom font CSS
            add_action('wp_enqueue_scripts', array($this, 'enqueue_custom_font'));
            add_action('admin_enqueue_scripts', array($this, 'enqueue_custom_font'));
            
            // Add custom CSS classes to body
            add_filter('body_class', array($this, 'add_custom_font_class'));
        }
    }
    
    /**
     * Enqueue custom font CSS
     */
    public function enqueue_custom_font() {
        if (self::is_custom_font_enabled()) {
            wp_enqueue_style(
                'bebanstore-custom-font',
                BEBANSTORE_PLUGIN_URL . 'assets/css/custom-font.css',
                array(),
                BEBANSTORE_VERSION
            );
        }
    }
    
    /**
     * Add custom font class to body
     */
    public function add_custom_font_class($classes) {
        if (self::is_custom_font_enabled()) {
            $classes[] = 'bebanstore-custom-font-enabled';
        }
        
        return $classes;
    }
    
    /**
     * Check if custom font is enabled
     */
    public static function is_custom_font_enabled() {
        $options = get_option('bebanstore_options', array());
        return isset($options['custom_font']) && $options['custom_font'];
    }
    
    /**
     * Get custom font CSS class
     */
    public static function get_font_class() {
        return self::is_custom_font_enabled() ? 'bebanstore-vazir-font' : '';
    }
}

