/**
 * Your Savings Feature JavaScript
 * 
 * @package BebanStore
 * @since 1.0.0
 */

jQuery(document).ready(function($) {
    'use strict';
    
    // Update "Your Savings" after cart changes
    $(document.body).on('updated_cart_totals', function() {
        updateCartSavings();
    });
    
    // Update "Your Savings" after checkout form updates
    $(document.body).on('updated_checkout', function() {
        updateCheckoutSavings();
    });
    
    /**
     * Update cart savings via AJAX
     */
    function updateCartSavings() {
        if (typeof beban_savings_ajax === 'undefined') {
            return;
        }
        
        $.ajax({
            url: beban_savings_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'beban_update_cart_savings',
                nonce: beban_savings_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Remove previous "Your Savings" row
                    $('.beban-cart-savings').remove();
                    
                    // Add new "Your Savings" row after order total
                    if (response.data.savings_html) {
                    $('.cart_totals table tbody tr.order-total').after(response.data.savings_html);
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('Error updating cart savings:', error);
            }
        });
    }
    
    /**
     * Update checkout savings (if needed)
     */
    function updateCheckoutSavings() {
        // This function can be extended for checkout-specific updates
        // Currently, checkout savings are updated server-side
    }
    
    /**
     * Initialize savings display
     */
    function initSavingsDisplay() {
        // Check if savings feature is enabled
        if ($('.beban-cart-savings, .beban-checkout-savings').length > 0) {
            // Feature is active, no additional initialization needed
        }
    }
    
    // Initialize on page load
    initSavingsDisplay();
}); 