jQuery(document).ready(function($) {
    'use strict';

        // Handle copy click
    $('.beban-copy-code').on('click', async function() {
            const code = $(this).data('code');

        try {
            // Try to copy using modern Clipboard API
            await navigator.clipboard.writeText(code);
            
            // Show success toast notification
            if (typeof BebanStoreToast !== 'undefined') {
                BebanStoreToast.info('کد رهگیری کپی شد');
            }
        } catch (err) {
            // Fallback to execCommand if Clipboard API fails
            const tempInput = $('<input>');
            $('body').append(tempInput);
            tempInput.val(code).select();

            try {
                document.execCommand('copy');
                
                // Show success toast notification
                if (typeof BebanStoreToast !== 'undefined') {
                    BebanStoreToast.info('کد رهگیری کپی شد');
                }
            } catch (fallbackErr) {
                // Show error toast notification
                if (typeof BebanStoreToast !== 'undefined') {
                    BebanStoreToast.error('خطا در کپی کردن کد رهگیری');
                }
            }

            tempInput.remove();
    }
    });
}); 