jQuery(document).ready(function($) {
    // تابع برای تبدیل اعداد فارسی به انگلیسی
    function convertPersianToEnglishNumbers(str) {
        var persianNumbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        var englishNumbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        
        for (var i = 0; i < 10; i++) {
            str = str.replace(new RegExp(persianNumbers[i], 'g'), englishNumbers[i]);
        }
        return str;
    }

    // تابع برای استخراج درصد از متن
    function extractProgressFromText(text) {
        // حذف فاصله‌ها و کاراکترهای اضافی
        text = text.trim();
        
        // تبدیل اعداد فارسی به انگلیسی
        text = convertPersianToEnglishNumbers(text);
        
        // جستجوی الگوی درصد (مثل "12%" یا "۱۲٪")
        var persianMatch = text.match(/(\d+)\s*٪/);
        var englishMatch = text.match(/(\d+)\s*%/);
        
        if (persianMatch) {
            return parseInt(persianMatch[1]);
        } else if (englishMatch) {
            return parseInt(englishMatch[1]);
        }
        
        // اگر الگوی درصد پیدا نشد، هر عددی را بگیر
        var numberMatch = text.match(/(\d+)/);
        if (numberMatch) {
            return parseInt(numberMatch[1]);
        }
        
        return 0;
    }

    // برای استایل نقطه‌ای
    $('.bebanstore-progress-dots').each(function() {
        var $progress = $(this);
        var $bar = $progress.find('.bebanstore-progress-bar');
        var progressText = $progress.find('.bebanstore-progress-text').text();
        var progress = extractProgressFromText(progressText);
        var dots = Math.ceil(progress / 10); // هر 10 درصد یک نقطه
        
        // ایجاد نقاط
        for (var i = 0; i < 10; i++) {
            $bar.append('<div class="bebanstore-progress-fill' + (i < dots ? ' active' : '') + '"></div>');
        }
    });

    // برای استایل دایره‌ای
    $('.bebanstore-progress-circular').each(function() {
        var $progress = $(this);
        var progressText = $progress.find('.bebanstore-progress-text').text();
        var progress = extractProgressFromText(progressText);
        var color = $progress.find('.bebanstore-progress-fill').css('background-color');
        
        // بررسی معتبر بودن progress
        if (!isNaN(progress) && progress >= 0 && progress <= 100) {
            $progress.find('.bebanstore-progress-bar').css({
                '--progress': progress + '%',
                '--progress-color': color
            });
        } else {
            // اگر progress معتبر نیست، از width استفاده کن
            var width = $progress.find('.bebanstore-progress-fill').css('width');
            var widthValue = parseInt(width);
            if (!isNaN(widthValue)) {
                $progress.find('.bebanstore-progress-bar').css({
                    '--progress': widthValue + '%',
                    '--progress-color': color
                });
            }
        }
    });
}); 