jQuery(document).ready(function($) {
    // بررسی وجود داده‌های متغیر
    if (typeof bebanstoreVariationData === 'undefined') {
        return;
    }

    // متغیرهای برای tracking
    var lastVariationId = null;
    var updateTimeout = null;
    var isUpdating = false;

    // تابع debounce برای جلوگیری از به‌روزرسانی‌های متعدد
    function debounce(func, wait) {
        return function() {
            var context = this;
            var args = arguments;
            if (updateTimeout) {
                clearTimeout(updateTimeout);
            }
            updateTimeout = setTimeout(function() {
                func.apply(context, args);
            }, wait);
        };
    }

    // تابع برای پیدا کردن variation_id با روش‌های مختلف
    function getSelectedVariationId() {
        // روش 1: از input hidden
        var variationId = $('input[name="variation_id"]').val();
        if (variationId && variationId !== '') {
            return parseInt(variationId);
        }
        
        // روش 2: از select field
        var selects = $('.variations select');
        if (selects.length > 0) {
            // بررسی آیا همه select ها انتخاب شده‌اند
            var allSelected = true;
            var variationIdFromSelects = null;
            
            selects.each(function() {
                var value = $(this).val();
                if (!value || value === '') {
                    allSelected = false;
                    return false; // break
                }
            });
            
            if (allSelected) {
                // جستجو در داده‌های variation برای پیدا کردن ID
                $.each(bebanstoreVariationData, function(id, data) {
                    var match = true;
                    selects.each(function() {
                        var attrName = $(this).attr('name');
                        var attrValue = $(this).val();
                        if (attrName && attrValue && data.attributes) {
                            var cleanAttrName = attrName.replace('attribute_', '');
                            if (!data.attributes[cleanAttrName] || data.attributes[cleanAttrName] !== attrValue) {
                                match = false;
                                return false; // break
                            }
                        }
                    });
                    if (match) {
                        variationIdFromSelects = parseInt(id);
                        return false; // break
                    }
                });
                
                if (variationIdFromSelects) {
                    return variationIdFromSelects;
                }
            }
        }
        
        return null;
    }

    // تابع به‌روزرسانی درصد تخفیف (بدون debounce - برای استفاده داخلی)
    function updateDiscountPercentageInternal() {
        // جلوگیری از اجرای همزمان
        if (isUpdating) {
            return;
        }
        
        isUpdating = true;
        
        // تاخیر کوچک برای اطمینان از به‌روزرسانی DOM
        setTimeout(function() {
            var selectedVariation = getSelectedVariationId();
            var discountElement = $('.beban-product-discount');
            
            // اگر variation تغییر نکرده و المان وجود دارد، هیچ کاری نکن
            if (selectedVariation === lastVariationId && discountElement.length > 0 && discountElement.is(':visible')) {
                isUpdating = false;
                return;
            }
            
            // به‌روزرسانی lastVariationId
            lastVariationId = selectedVariation;
            
            if (selectedVariation && bebanstoreVariationData[selectedVariation]) {
                var variation = bebanstoreVariationData[selectedVariation];
                
                if (discountElement.length === 0) {
                    isUpdating = false;
                    return; // المان وجود ندارد
                }
                
                // به‌روزرسانی متن و استایل - استفاده از ساختار مشابه محصولات عادی
                discountElement.html(
                    '<span class="beban-discount-value-number">' + variation.discount + '</span>' +
                    '<span class="beban-discount-value-icon">' + 
                        '<svg xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" width="12" height="13" viewBox="0 0 12 13" fill="none">' +
                            '<path d="M3.51562 9.43164L10.0156 2.93164" stroke="' + bebanstoreDiscountSettings.text_color + '" stroke-width="2px" stroke-linecap="round" stroke-linejoin="round" fill="none"/>' +
                            '<path d="M9.46875 8.89062H9.48132" stroke="' + bebanstoreDiscountSettings.text_color + '" stroke-width="3px" stroke-linecap="round" stroke-linejoin="round" fill="none"/>' +
                            '<path d="M4.05134 3.47331H4.06107" stroke="' + bebanstoreDiscountSettings.text_color + '" stroke-width="3px" stroke-linecap="round" stroke-linejoin="round" fill="none"/></svg>' +
                    '</span>'
                );
                discountElement.css({
                    'background-color': bebanstoreDiscountSettings.background_color,
                    'color': bebanstoreDiscountSettings.text_color,
                    'display': 'inline-flex'
                });
                discountElement.stop(true, true).fadeIn(200); // نمایش با انیمیشن نرم
            } else {
                // مخفی کردن المان اگر متغیری انتخاب نشده
                if (discountElement.length > 0) {
                    discountElement.stop(true, true).fadeOut(200, function() {
                        $(this).hide();
                    }); // مخفی کردن با انیمیشن نرم
                }
            }
            
            isUpdating = false;
        }, 100); // تاخیر 100 میلی‌ثانیه برای اطمینان از به‌روزرسانی DOM
    }

    // تابع به‌روزرسانی با debounce
    var updateDiscountPercentage = debounce(updateDiscountPercentageInternal, 150);

    // اضافه کردن رویداد تغییر متغیر - استفاده از رویدادهای متعدد
    var variationForm = $('form.variations_form');
    
    if (variationForm.length > 0) {
        // رویداد show_variation - زمانی که variation نمایش داده می‌شود
        variationForm.on('show_variation', function(event, variation, purchasable) {
            updateDiscountPercentage();
        });
        
        // رویداد hide_variation - زمانی که variation مخفی می‌شود
        variationForm.on('hide_variation', function() {
            if (updateTimeout) {
                clearTimeout(updateTimeout);
            }
            lastVariationId = null;
            $('.beban-product-discount').stop(true, true).fadeOut(200, function() {
                $(this).hide();
            });
        });
        
        // رویداد found_variation - زمانی که variation پیدا می‌شود
        variationForm.on('found_variation', function(event, variation) {
            updateDiscountPercentage();
        });
        
        // رویداد woocommerce_variation_has_changed - زمانی که variation تغییر می‌کند
        variationForm.on('woocommerce_variation_has_changed', function() {
            updateDiscountPercentage();
        });
        
        // رویداد change روی select ها - برای اطمینان از تشخیص تغییرات (با debounce)
        variationForm.on('change', '.variations select', function() {
            // تاخیر برای اطمینان از به‌روزرسانی DOM
            setTimeout(function() {
                updateDiscountPercentage();
            }, 50);
        });
        
        // رویداد change روی input hidden variation_id
        variationForm.on('change', 'input[name="variation_id"]', function() {
            updateDiscountPercentage();
        });
        
        // رویداد update_variation_values - زمانی که مقادیر variation به‌روزرسانی می‌شوند
        $(document.body).on('update_variation_values', function() {
            updateDiscountPercentage();
        });
        
        // اگر مقدار پیش‌فرض وجود دارد، آن را نمایش بده
        $(document).ready(function() {
            setTimeout(function() {
                var defaultVariation = getSelectedVariationId();
                if (defaultVariation && bebanstoreVariationData[defaultVariation]) {
                    // فقط یک بار در ابتدا
                    lastVariationId = defaultVariation;
                    updateDiscountPercentageInternal();
                }
            }, 300); // تاخیر بیشتر برای اطمینان از بارگذاری کامل
        });
    }
});