jQuery(function($) {
    'use strict';

    /**
     * Initialize express shipping tooltips
     */
    function initExpressShippingTooltips() {
        // Add tooltip functionality to express shipping badges
        $('.beban-express-badge[data-tooltip]').each(function() {
            const $badge = $(this);
            const tooltipText = $badge.attr('data-tooltip');
            
            if (!tooltipText) {
                return;
            }

            // Create tooltip element
            const $tooltip = $('<div class="beban-express-tooltip">' + tooltipText + '</div>');
            $('body').append($tooltip);

            // Show tooltip on hover
            $badge.on('mouseenter', function() {
                const badgeRect = this.getBoundingClientRect();
                
                // Position tooltip above the badge
                const left = badgeRect.left + (badgeRect.width / 2);
                const top = badgeRect.top - 8;
                
                $tooltip.css({
                    left: left + 'px',
                    top: top + 'px',
                    opacity: 1,
                    visibility: 'visible'
                });
            });

            // Hide tooltip on mouse leave
            $badge.on('mouseleave', function() {
                $tooltip.css({
                    opacity: 0,
                    visibility: 'hidden'
                });
            });
        });
    }

    // Initialize on page load
    initExpressShippingTooltips();

    // Initialize when cart is updated
    $(document.body).on('updated_cart_totals', function() {
        initExpressShippingTooltips();
    });

    // Initialize when fragments are updated
    $(document.body).on('wc_fragments_refreshed', function() {
        initExpressShippingTooltips();
    });

    // Initialize when variations are loaded
    $(document.body).on('found_variation', function() {
        initExpressShippingTooltips();
    });
}); 