<?php
/**
 * Product settings tab template
 * 
 * @package BebanStore
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get feature settings
$factory = new BebanStore_Feature_Settings_Factory();
$product_features = array(
    'ajax_add_to_cart',
    'add_to_cart_button_text',
    'wishlist',
    'countdown',
    'custom_quantity_control',
    'product_attributes',
    'product_discount',
    'discount_badges',
    'variable_price',
    'express_shipping',
    'sales_progress',
    'product_mentions_in_content', // Pro feature preview
);

// Allow Pro features to register for product tab
$pro_product_features = apply_filters('bebanstore_pro_product_features', array());
$product_features = array_merge($product_features, $pro_product_features);

$feature_settings = array();
foreach ($product_features as $feature_id) {
    $feature_settings[$feature_id] = $factory->get_settings($feature_id);
}

// Get current options
$options = get_option('bebanstore_options', array());
$feature_options = isset($options['feature_settings']) ? $options['feature_settings'] : array();
?>
<div class="bebanstore-product-settings">
    <div class="bebanstore-section-header">
        <h2><?php _e('تنظیمات محصولات', 'bebanstore'); ?></h2>
        <p><?php _e('در این بخش می‌توانید تنظیمات مربوط به محصولات را مدیریت کنید.', 'bebanstore'); ?></p>
    </div>
    
    <div class="bebanstore-settings-list">
        <?php if (empty($feature_settings)) : ?>
            <div class="bebanstore-empty-tab">
                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-5 14H4v-4h11v4zm0-5H4V9h11v4zm5 5h-4V9h4v9z"/>
                </svg>
                <h3><?php _e('تنظیمات محصولات', 'bebanstore'); ?></h3>
                <p><?php _e('در حال حاضر تنظیماتی برای نمایش وجود ندارد.', 'bebanstore'); ?></p>
            </div>
        <?php else : ?>
            <?php foreach ($feature_settings as $feature_id => $feature_setting) :
                if (empty($feature_setting)) {
                    continue;
                }
                
                $feature_status = BebanStore_Feature_Status::get_feature_status($feature_id);
                $status_badge = BebanStore_Feature_Status::get_status_badge($feature_status);
                $is_checkbox_enabled = BebanStore_Feature_Status::should_enable_checkbox($feature_id);
                ?>
            <div class="bebanstore-setting-row">
                <div class="bebanstore-setting-info">
                    <div class="bebanstore-setting-header">
                        <div class="bebanstore-field-wrapper">
                            <?php
                                $feature_status = BebanStore_Feature_Status::get_feature_status($feature_id);
                                
                                if (BebanStore_Feature_Status::should_enable_checkbox($feature_id)) {
                                    // چک‌باکس فعال برای active و beta
                                    $this->render_checkbox_field($feature_id, '');
                                    
                                    // نمایش دکمه تنظیمات در کنار چک‌باکس
                                    if (BebanStore_Feature_Status::should_show_settings_button($feature_id)) {
                                        $this->render_additional_settings_button($feature_id, $feature_settings, $options);
                                    }
                                    
                                    // نمایش badge ویژگی (Pro یا Freemium)
                                    $this->render_feature_badges($feature_id, $feature_setting);
                                } else {
                                    // فقط badge برای سایر وضعیت‌ها
                                    echo BebanStore_Feature_Status::get_status_badge($feature_status);
                                }
                                ?>
                            </div>
                            <h3 class="bebanstore-setting-title">
                                <?php echo esc_html($feature_setting['name']); ?>
                                <?php 
                                // نمایش badge وضعیت در کنار عنوان فقط برای active و beta (ولی نه برای ویژگی‌های پرو)
                                if (BebanStore_Feature_Status::should_enable_checkbox($feature_id)) {
                                    // badge وضعیت را فقط برای non-pro features نمایش بده
                                    if (!isset($feature_setting['is_pro_feature']) || !$feature_setting['is_pro_feature']) {
                                        echo $status_badge;
                                    }
                                }
                                ?>
                            </h3>
                        </div>
                        <p class="bebanstore-setting-description"><?php echo esc_html($feature_setting['description']); ?></p>
                    <div class="bebanstore-setting-control">
                            <div class="bebanstore-setting-subsettings" data-feature="<?php echo esc_attr($feature_id); ?>" style="display: none;">
                                <?php 
                                // بررسی اینکه آیا ویژگی shortcode یا help دارد (حتی اگر settings خالی باشد)
                                $has_shortcode_in_settings = isset($feature_setting['shortcode']) && !empty($feature_setting['shortcode']);
                                $has_help_in_settings = isset($feature_setting['help']) && !empty($feature_setting['help']);
                                $has_warning_in_settings = isset($feature_setting['warning']) && !empty($feature_setting['warning']);
                                $has_pro_elementor_in_settings = isset($feature_setting['has_pro_elementor']) && $feature_setting['has_pro_elementor'];
                                
                                // اگر has_settings true است یا shortcode/help دارد، render_tabbed_settings را فراخوانی کن
                                if ((isset($feature_setting['has_settings']) && $feature_setting['has_settings']) || 
                                    $has_shortcode_in_settings || 
                                    $has_help_in_settings || 
                                    $has_warning_in_settings || 
                                    $has_pro_elementor_in_settings) {
                                    // Render tabbed settings
                                    $this->render_tabbed_settings($feature_id, $feature_setting, $feature_options);
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>
