<?php
/**
 * Advanced settings tab template
 * 
 * @package BebanStore
 * @since 1.0.4
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get current options
$options = get_option('bebanstore_options', array());
$custom_css = isset($options['custom_css']) ? $options['custom_css'] : '';
?>

<div class="bebanstore-advanced-settings">
    <div class="bebanstore-section-header">
        <h2><?php _e('تنظیمات پیشرفته', 'bebanstore'); ?></h2>
        <p><?php _e('تنظیمات پیشرفته افزونه شامل کدهای سفارشی و عملیات سیستمی', 'bebanstore'); ?></p>
    </div>
    
    <div class="bebanstore-settings-list">
        
        <!-- Custom CSS Section -->
        <div class="bebanstore-setting-row bebanstore-advanced-section">
            <div class="bebanstore-setting-info">
                <div class="bebanstore-setting-header">
                    <div class="bebanstore-section-icon">
    
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21 7V17C21 20 19.5 22 16 22H8C4.5 22 3 20 3 17V7C3 4 4.5 2 8 2H16C19.5 2 21 4 21 7Z" stroke="#667eea" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M14.5 4.5V6.5C14.5 7.6 15.4 8.5 16.5 8.5H18.5" stroke="#667eea" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M10 13L8 15L10 17" stroke="#667eea" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M14 13L16 15L14 17" stroke="#667eea" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div>
                        <h3 class="bebanstore-setting-title"><?php _e('کدهای CSS سفارشی', 'bebanstore'); ?></h3>
                        <p class="bebanstore-setting-description">
                            <?php _e('افزودن کدهای CSS سفارشی برای ظاهر ویژگی‌های افزونه', 'bebanstore'); ?>
                        </p>
                    </div>
                </div>
                
                <div class="bebanstore-css-editor-wrapper">
                    <div class="bebanstore-editor-toolbar">
                        
                        <div class="bebanstore-css-location-selector">
                            <label for="bebanstore_css_location" class="bebanstore-location-label">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12 2L13.09 8.26L22 9L13.09 9.74L12 16L10.91 9.74L2 9L10.91 8.26L12 2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <?php _e('محل اعمال:', 'bebanstore'); ?>
                            </label>
                            <select id="bebanstore_css_location" name="bebanstore_options[css_location]" class="bebanstore-location-select">
                                <option value="inline_head" <?php selected(isset($options['css_location']) ? $options['css_location'] : 'inline_head', 'inline_head'); ?>>
                                    <?php _e('اینلاین - Head', 'bebanstore'); ?>
                                </option>
                                <option value="inline_body" <?php selected(isset($options['css_location']) ? $options['css_location'] : 'inline_head', 'inline_body'); ?>>
                                    <?php _e('اینلاین - انتهای Body', 'bebanstore'); ?>
                                </option>
                                <option value="file_head" <?php selected(isset($options['css_location']) ? $options['css_location'] : 'inline_head', 'file_head'); ?>>
                                    <?php _e('فایل مجزا - Head', 'bebanstore'); ?>
                                </option>
                                <option value="file_body" <?php selected(isset($options['css_location']) ? $options['css_location'] : 'inline_head', 'file_body'); ?>>
                                    <?php _e('فایل مجزا - انتهای Body', 'bebanstore'); ?>
                                </option>
                            </select>
                            <div class="bebanstore-location-hint">
                                <span class="hint-text" data-location="inline_head">
                                    💡 <?php _e('کدها به صورت inline در تگ head اضافه می‌شوند - سریع‌ترین روش', 'bebanstore'); ?>
                                </span>
                                <span class="hint-text" data-location="inline_body" style="display: none;">
                                    💡 <?php _e('کدها به صورت inline در انتهای body اضافه می‌شوند - برای کدهای حجیم', 'bebanstore'); ?>
                                </span>
                                <span class="hint-text" data-location="file_head" style="display: none;">
                                    💡 <?php _e('کدها در فایل CSS مجزا ذخیره و در head لود می‌شوند - بهترین performance', 'bebanstore'); ?>
                                </span>
                                <span class="hint-text" data-location="file_body" style="display: none;">
                                    💡 <?php _e('کدها در فایل CSS مجزا ذخیره و در انتهای body لود می‌شوند - متعادل', 'bebanstore'); ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="bebanstore-editor-actions">
                            <button type="button" class="bebanstore-editor-btn" data-action="format" title="<?php _e('مرتب کردن کد', 'bebanstore'); ?>">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M3 6H21" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M3 12H15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M3 18H9" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <?php _e('مرتب کردن', 'bebanstore'); ?>
                            </button>
                            
                            <button type="button" class="bebanstore-editor-btn" data-action="minify" title="<?php _e('فشرده کردن کد', 'bebanstore'); ?>">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 12L11 14L15 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <?php _e('فشرده', 'bebanstore'); ?>
                            </button>
                            
                            <button type="button" class="bebanstore-editor-btn" data-action="unminify" title="<?php _e('باز کردن از حالت فشرده', 'bebanstore'); ?>">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8 12H16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12 8V16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <?php _e('باز کردن', 'bebanstore'); ?>
                            </button>
                            
                            
                            <div class="bebanstore-editor-stats">
                                <span class="lines"><?php _e('خطوط:', 'bebanstore'); ?> <strong>0</strong></span>
                                <span class="chars"><?php _e('کاراکتر:', 'bebanstore'); ?> <strong>0</strong></span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bebanstore-editor-container">
                        <textarea 
                            id="bebanstore_custom_css" 
                            name="bebanstore_options[custom_css]" 
                            class="bebanstore-code-editor"
                            rows="15"
                            placeholder="/* مثال:&#10;.bebanstore-wishlist-button {&#10;    background-color: #ff0000;&#10;    border-radius: 10px;&#10;}&#10;*/"
                            spellcheck="false"
                        ><?php echo esc_textarea($custom_css); ?></textarea>
                    </div>
                    
                </div>
            </div>
        </div>
        
    </div>
</div>

