<?php
/**
 * About tab template
 * 
 * @package BebanStore
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get all features
$all_features = array();
foreach ($this->features as $feature) {
    $all_features[] = array(
        'title' => $feature->get_title(),
        'is_enabled' => $feature->is_enabled()
    );
}
?>
<div class="bebanstore-about-content">
    <h2><?php printf(__('درباره افزونه %s', 'bebanstore'), BEBANSTORE_PLUGIN_NAME); ?></h2>
    <p><?php printf(__('افزونه %s یک افزونه جامع برای بهبود فروشگاه‌های ووکامرس است که امکانات متنوعی را برای بهبود تجربه کاربری در اختیار شما قرار می‌دهد.', 'bebanstore'), BEBANSTORE_PLUGIN_NAME); ?></p>
    <p class="bebanstore-version"><?php printf(__('نسخه فعلی: %s', 'bebanstore'), BEBANSTORE_VERSION); ?></p>
    <h3 class="bebanstore-features-title">
        <?php _e('ویژگی‌های افزونه', 'bebanstore'); ?>
        <span class="bebanstore-features-count"><?php echo count($all_features); ?></span>
    </h3>
    <ul class="bebanstore-features-list">
        <?php foreach ($all_features as $feature) : ?>
            <li class="<?php echo $feature['is_enabled'] ? 'feature-enabled' : 'feature-disabled'; ?>">
                <?php echo esc_html($feature['title']); ?>
                <span class="feature-status">
                    <?php echo $feature['is_enabled'] ? __('فعال', 'bebanstore') : __('غیرفعال', 'bebanstore'); ?>
                </span>
            </li>
        <?php endforeach; ?>
    </ul>

    <div class="bebanstore-support-section">
        <h3><?php _e('پشتیبانی', 'bebanstore'); ?></h3>
        <p><?php _e('برای دریافت پشتیبانی و گزارش مشکلات به وبسایت ببان مراجعه کنید:', 'bebanstore'); ?></p>
        <p><a href="https://beban.ir/bebanstore" target="_blank">https://beban.ir/bebanstore</a></p>
    </div>
</div> 