<?php
/**
 * Main settings page template
 * 
 * This template renders the main settings page for the BebanStore plugin.
 * It includes tabs for different settings sections and handles form submission.
 * 
 * @package BebanStore
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define available tabs
$available_tabs = array(
    'general' => __('عمومی', 'bebanstore'),
    'cart' => __('سبد خرید', 'bebanstore'),
    'product' => __('محصول', 'bebanstore'),
    'account' => __('حساب کاربری', 'bebanstore'),
    'checkout' => __('تسویه حساب', 'bebanstore'),
    'thank-you' => __('صفحه تشکر', 'bebanstore'),
    'advanced' => __('پیشرفته', 'bebanstore'),
    'about' => __('درباره ما', 'bebanstore')
);
?>
<div class="wrap bebanstore-settings">
    <?php $this->render_tabs(); ?>
    
    <div class="bebanstore-tab-content">
        <form method="post" action="options.php" class="bebanstore-settings-form" id="bebanstore-settings-form">
            <?php
            // Store active tab in hidden field
            printf(
                '<input type="hidden" name="bebanstore_active_tab" value="%s">',
                esc_attr($this->active_tab)
            );
            
            // Hook before settings fields
            do_action('bebanstore_before_settings_fields', $this->active_tab);
            
            // Add security fields
            wp_nonce_field('bebanstore_options-options');
            printf(
                '<input type="hidden" name="option_page" value="%s">',
                esc_attr('bebanstore_options')
            );
            echo '<input type="hidden" name="action" value="update">';
            
            // Add settings fields for all tabs
            settings_fields('bebanstore_options');
            do_settings_sections('bebanstore_options');
            
            // Render tab contents
            foreach ($available_tabs as $tab_id => $tab_name) {
                $display = $tab_id === $this->active_tab ? 'block' : 'none';
                printf(
                    '<div class="bebanstore-tab-pane" data-tab="%s" style="display: %s;">',
                    esc_attr($tab_id),
                    esc_attr($display)
                );
                
                // Include tab content
                $tab_file = BEBANSTORE_PLUGIN_DIR . 'admin/views/tabs/' . $tab_id . '.php';
                if (file_exists($tab_file)) {
                    include $tab_file;
                }
                
                echo '</div>';
            }
            
            // Hook after settings fields
            do_action('bebanstore_after_settings_fields', $this->active_tab);
            
            // Add submit button
            submit_button(__('ذخیره تنظیمات', 'bebanstore'));
            ?>
        </form>
    </div>
</div>

<!-- Shortcode Modal Template -->
<?php 
$modal_file = BEBANSTORE_PLUGIN_DIR . 'admin/views/components/shortcode-modal.php';
if (file_exists($modal_file)) {
    include $modal_file;
}
?> 