<?php
/**
 * Sales Progress Settings
 * 
 * @package BebanStore
 * @since 1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'sales_progress',
    'name' => 'نمایش پیشرفت فروش',
    'description' => 'نمایش نوار پیشرفت فروش برای محصولات به کاربران کمک می‌کند تا از وضعیت فروش محصول مطلع شوند',
    'help' => array(
        'title' => 'راهنمای استفاده از نوار پیشرفت فروش',
        'content' => 'این ویژگی به شما امکان می‌دهد نوار پیشرفت فروش را برای محصولات نمایش دهید تا مشتریان از میزان فروش و محبوبیت هر محصول آگاه شوند. <strong>نکته بسیار مهم:</strong> برای عملکرد صحیح این ویژگی، حتماً باید در بخش ویرایش محصول، تنظیمات موجودی را فعال کرده و مقدار موجودی انبار را مشخص کنید، در غیر این صورت نوار پیشرفت فروش نمایش داده نخواهد شد. دو استایل مختلف برای نمایش در اختیار شماست: <strong>استایل خطی</strong> که نوار پیشرفت به صورت افقی و زیر اطلاعات محصول نمایش داده می‌شود، و <strong>استایل دایره‌ای</strong> که پیشرفت فروش به صورت یک دایره با درصد در مرکز آن نمایش داده می‌شود. شما می‌توانید رنگ‌های مختلف نوار پیشرفت را از بخش تنظیمات شخصی‌سازی کنید. برای نمایش نوار پیشرفت در صفحات دلخواه، از شورتکد <code>[beban_sales_progress]</code> استفاده نمایید.'
    ),
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات محتوا
        'content_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات محتوا', 'bebanstore'),
            'description' => __('متن و نحوه نمایش نوار پیشرفت را تنظیم کنید', 'bebanstore')
        ),
        'sold_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => 'متن فروش',
            'default' => 'فروش',
            'required' => true
        ),
        'progress_style' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'استایل نوار',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'انتخاب کنید که نوار پیشرفت فروش به صورت افقی (خطی) یا دایره‌ای نمایش داده شود'
                )
            ),
            'default' => 'linear',
            'options' => array(
                'linear' => 'خطی',
                'circular' => 'دایره‌ای'
            )
        ),
        'min_sales' => array(
            'tab' => 'content',
            'type' => 'number',
            'label' => 'حداقل فروش',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'نوار پیشرفت فقط برای محصولاتی نمایش داده می‌شود که حداقل این تعداد فروش را داشته باشند (0 = همیشه نمایش داده شود)'
                )
            ),
            'default' => 0,
            'min' => 0
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌بندی
        'style_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌بندی', 'bebanstore'),
            'description' => __('رنگ نوار پیشرفت فروش را تنظیم کنید', 'bebanstore')
        ),
        'progress_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => 'رنگ نوار پیشرفت',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'رنگ نوار پیشرفت فروش محصول'
                )
            ),
            'default' => '#f50049'
        )
    )
); 