<?php
/**
 * Product Attributes Feature Settings
 * 
 * @package BebanStore
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'product_attributes',
    'name' => 'ویژگی‌های محصول',
    'description' => 'نمایش ویژگی‌های محصول در قالب گرید زیبا و کاربرپسند',
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات نمایش
        'display_settings_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات نمایش', 'bebanstore'),
            'description' => __('تعداد و نحوه نمایش ویژگی‌های محصول را تنظیم کنید', 'bebanstore')
        ),
        'max_attributes' => array(
            'tab' => 'content',
            'type' => 'number',
            'label' => __('حداکثر تعداد', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('حداکثر تعداد ویژگی‌هایی که در گرید نمایش داده می‌شوند (باقی ویژگی‌ها مخفی می‌مانند)', 'bebanstore')
                )
            ),
            'default' => 9,
            'min' => 1,
            'max' => 20,
            'required' => true
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌بندی
        'colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌بندی', 'bebanstore'),
            'description' => __('رنگ‌های گرید ویژگی‌های محصول را تنظیم کنید', 'bebanstore')
        ),
        'background_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ پس‌زمینه گرید ویژگی‌های محصول', 'bebanstore')
                )
            ),
            'default' => '#FAFBFB'
        ),
        'text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن مقادیر', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن مقادیر ویژگی‌های محصول (مثل وزن، ابعاد و...)', 'bebanstore')
                )
            ),
            'default' => '#333333'
        ),
        'label_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن برچسب‌ها', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('رنگ متن نام ویژگی‌های محصول (مثل وزن، ابعاد و...)', 'bebanstore')
                )
            ),
            'default' => '#888888'
        )
    )
); 