<?php
/**
 * Discount Badges Feature Settings
 *
 * @package BebanStore
 * @since 1.0.0
 */

return array(
    'id' => 'discount_badges',
    'name' => 'نشان‌های تخفیف',
    'description' => 'نمایش نشان‌های تخفیف برای محصولات با تخفیف',
    'help' => array(
        'title' => 'راهنمای استفاده از نشان‌های تخفیف',
        'content' => 'این ویژگی به شما امکان می‌دهد نشان‌های بصری جذاب برای محصولات دارای تخفیف نمایش دهید. دو نوع نشان تخفیف در اختیار شماست: <strong>نشان تخفیف محصول</strong> که برای تمام محصولاتی که قیمت حراج دارند نمایش داده می‌شود، و <strong>نشان تخفیف ویژه</strong> که مخصوص محصولاتی است که علاوه بر تخفیف، زمان‌بندی محدود (زمان شروع و پایان حراج) نیز برای آن‌ها تعیین شده است. این نشان‌ها به صورت خودکار بر اساس وضعیت تخفیف هر محصول نمایش داده می‌شوند. شما می‌توانید تصاویر سفارشی (SVG، PNG یا JPG) برای هر نوع نشان آپلود کنید تا با هویت بصری فروشگاه خود هماهنگ باشد. برای نمایش نشان‌های تخفیف در صفحات دلخواه، می‌توانید از شورتکد <code>[beban_discount_badges]</code> استفاده کنید.'
    ),
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تصاویر نشان‌ها
        'badges_images_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تصاویر نشان‌های تخفیف', 'bebanstore'),
            'description' => __('تصاویر نمایشی برای انواع مختلف نشان‌های تخفیف را انتخاب کنید', 'bebanstore')
        ),
        'product_discount_image' => array(
            'tab' => 'content',
            'type' => 'media_uploader',
            'label' => __('تصویر تخفیف عادی', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('تصویر نشان تخفیف معمولی که روی محصولات دارای تخفیف نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => BEBANSTORE_PLUGIN_URL . 'assets/img/sell.svg',
            'button_text' => __('انتخاب تصویر', 'bebanstore'),
            'remove_text' => __('حذف تصویر', 'bebanstore')
        ),
        'category_discount_image' => array(
            'tab' => 'content',
            'type' => 'media_uploader',
            'label' => __('تصویر تخفیف ویژه', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('تصویر نشان تخفیف ویژه که روی محصولات دارای تخفیف و زمان محدود نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => BEBANSTORE_PLUGIN_URL . 'assets/img/SpecialSell.svg',
            'button_text' => __('انتخاب تصویر', 'bebanstore'),
            'remove_text' => __('حذف تصویر', 'bebanstore')
        )
    )
); 