<?php
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'checkout_fields_manager',
    'name' => 'مدیریت فیلدهای صفحه تسویه حساب',
    'description' => 'امکان مدیریت و سفارشی‌سازی فیلدهای صفحه تسویه حساب ووکامرس',
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه فیلدهای اطلاعات سازمانی
        'organizational_fields_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => 'فیلدهای اطلاعات سازمانی',
            'description' => 'وضعیت نمایش فیلدهای مرتبط با شرکت و سازمان را تنظیم کنید'
        ),
        'company' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'شرکت',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'تعیین کنید فیلد «نام شرکت» چگونه نمایش داده شود'
                )
            ),
            'default' => 'default',
            'options' => array(
                'default'  => 'پیشفرض',
                'hidden'   => 'مخفی',
                'optional' => 'اختیاری',
                'required' => 'اجباری',
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        // گروه فیلدهای موقعیت جغرافیایی
        'location_fields_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => 'فیلدهای موقعیت جغرافیایی',
            'description' => 'وضعیت نمایش فیلدهای کشور، استان و شهر را مدیریت کنید'
        ),
        'country' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'کشور',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'تعیین کنید فیلد «کشور» چگونه نمایش داده شود'
                )
            ),
            'default' => 'default',
            'options' => array(
                'default'  => 'پیشفرض',
                'hidden'   => 'مخفی',
                'optional' => 'اختیاری',
                'required' => 'اجباری',
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'state' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'استان',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'تعیین کنید فیلد «استان» چگونه نمایش داده شود'
                )
            ),
            'default' => 'default',
            'options' => array(
                'default'  => 'پیشفرض',
                'hidden'   => 'مخفی',
                'optional' => 'اختیاری',
                'required' => 'اجباری',
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'city' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'شهر',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'تعیین کنید فیلد «شهر» چگونه نمایش داده شود'
                )
            ),
            'default' => 'default',
            'options' => array(
                'default'  => 'پیشفرض',
                'hidden'   => 'مخفی',
                'optional' => 'اختیاری',
                'required' => 'اجباری',
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        
        // گروه فیلدهای آدرس
        'address_fields_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => 'فیلدهای آدرس',
            'description' => 'وضعیت نمایش فیلدهای آدرس و کد پستی را تنظیم کنید'
        ),
        'address_1' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'آدرس',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'تعیین کنید فیلد «آدرس» چگونه نمایش داده شود'
                )
            ),
            'default' => 'default',
            'options' => array(
                'default'  => 'پیشفرض',
                'hidden'   => 'مخفی',
                'optional' => 'اختیاری',
                'required' => 'اجباری',
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'address_2' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'آدرس تکمیلی',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'تعیین کنید فیلد «آدرس تکمیلی» چگونه نمایش داده شود'
                )
            ),
            'default' => 'default',
            'options' => array(
                'default'  => 'پیشفرض',
                'hidden'   => 'مخفی',
                'optional' => 'اختیاری',
                'required' => 'اجباری',
            ),
            'sanitize_callback' => 'sanitize_text_field'
        ),
        'postcode' => array(
            'tab' => 'content',
            'type' => 'select',
            'label' => 'کد پستی',
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => 'تعیین کنید فیلد «کد پستی» چگونه نمایش داده شود'
                )
            ),
            'default' => 'default',
            'options' => array(
                'default'  => 'پیشفرض',
                'hidden'   => 'مخفی',
                'optional' => 'اختیاری',
                'required' => 'اجباری',
            ),
            'sanitize_callback' => 'sanitize_text_field'
        )
    )
); 