<?php
/**
 * Cart Confirmation Feature Settings
 *
 * @package BebanStore
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'cart_confirmation',
    'name' => __('پاپ آپ حذف محصول', 'bebanstore'),
    'description' => __('نمایش پنجره تایید قبل از حذف محصول از سبد خرید', 'bebanstore'),
    'has_settings' => true,
    'has_pro_settings' => false,
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه متن‌های مودال
        'modal_texts_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('متن‌های مودال', 'bebanstore'),
            'description' => __('متن‌های نمایش داده شده در مودال تأیید حذف را تنظیم کنید', 'bebanstore')
        ),
        'modal_title' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('عنوان مودال', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('عنوان پنجره تأیید حذف محصول از سبد خرید', 'bebanstore')
                )
            ),
            'default' => 'تایید حذف محصول',
            'required' => true,
            'status' => 'active'
        ),
        'confirmation_message' => array(
            'tab' => 'content',
            'type' => 'textarea',
            'label' => __('پیام تایید', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('پیام توضیحی که در پنجره تأیید حذف نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'آیا مطمئن هستید که می‌خواهید این محصول را از سبد خرید حذف کنید؟',
            'status' => 'active'
        ),
        'confirm_button_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن دکمه تایید', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('متن دکمه تأیید حذف محصول از سبد خرید', 'bebanstore')
                )
            ),
            'default' => 'بله، حذف شود',
            'status' => 'active'
        ),
        'cancel_button_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن دکمه انصراف', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('متن دکمه انصراف از حذف محصول', 'bebanstore')
                )
            ),
            'default' => 'انصراف',
            'required' => true,
            'status' => 'active'
        ),
        
        // ========== تب استایل ==========
        
        // گروه رنگ‌های مودال
        'modal_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌های مودال', 'bebanstore'),
            'description' => __('رنگ پس‌زمینه و متن‌های مودال را تنظیم کنید', 'bebanstore')
        ),
        'modal_background_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه مودال', 'bebanstore'),
            'default' => '#ffffff',
            'status' => 'active'
        ),
        'modal_title_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ عنوان مودال', 'bebanstore'),
            'default' => '#000000',
            'status' => 'active'
        ),
        'modal_description_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن توضیحات', 'bebanstore'),
            'default' => '#666666',
            'status' => 'active'
        ),
        
        // گروه رنگ‌های دکمه‌ها
        'buttons_colors_section' => array(
            'type' => 'section_header',
            'tab' => 'style',
            'title' => __('رنگ‌های دکمه‌ها', 'bebanstore'),
            'description' => __('رنگ‌های دکمه‌های تأیید و انصراف را تنظیم کنید', 'bebanstore')
        ),
        'confirm_button_bg_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه دکمه تایید', 'bebanstore'),
            'default' => '#dc3545',
            'status' => 'active'
        ),
        'confirm_button_text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن دکمه تایید', 'bebanstore'),
            'default' => '#ffffff',
            'status' => 'active'
        ),
        'cancel_button_bg_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ پس‌زمینه دکمه انصراف', 'bebanstore'),
            'default' => '#ffffff',
            'status' => 'active'
        ),
        'cancel_button_text_color' => array(
            'tab' => 'style',
            'type' => 'color',
            'label' => __('رنگ متن دکمه انصراف', 'bebanstore'),
            'default' => '#007bff',
            'status' => 'active'
        )
    ),
    'warning' => array(
        'title' => __('هشدار محدودیت', 'bebanstore'),
        'content' => __('لطفاً توجه داشته باشید که این ویژگی تنها برای دکمه‌های حذف پیش‌فرض ووکامرس (دکمه ضربدر یا Remove) طراحی شده و کار می‌کند. در صورتی که از ویژگی "دکمه‌های افزایش/کاهش محصول" همراه با گزینه "دکمه سطل زباله" استفاده می‌کنید، این ویژگی "پاپ‌آپ تأیید حذف" روی دکمه سطل زباله اعمال نخواهد شد، زیرا ویژگی دکمه‌های افزایش/کاهش دارای سیستم پاپ‌آپ اختصاصی و جداگانه خود است. برای کنترل نحوه نمایش پاپ‌آپ تأیید حذف محصول در حالت استفاده از دکمه سطل زباله، باید از تنظیمات داخلی همان ویژگی "دکمه‌های افزایش/کاهش محصول" استفاده کنید.', 'bebanstore')
    )
); 