<?php
/**
 * Add to Cart Button Text Management Settings
 * 
 * @package BebanStore
 * @since 1.0.6
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'add_to_cart_button_text',
    'name' => __('مدیریت متن دکمه افزودن به سبد', 'bebanstore'),
    'description' => __('تغییر متن دکمه افزودن به سبد خرید', 'bebanstore'),
    'has_settings' => true,
    'has_pro_settings' => true,
    'help' => array(
        'title' => __('راهنمای مدیریت متن دکمه', 'bebanstore'),
        'content' => __('با این ویژگی می‌توانید متن دکمه "افزودن به سبد خرید" را تغییر دهید. در نسخه رایگان، متن تنظیم شده برای تمام محصولات اعمال می‌شود. نسخه Pro  پیشرفته‌تری مانند تنظیم جداگانه برای هر نوع محصول را ارائه می‌دهد.', 'bebanstore')
    ),
    'settings' => array(
        
        // ========== تب محتوا ==========
        
        // گروه تنظیمات متن دکمه
        'button_text_section' => array(
            'type' => 'section_header',
            'tab' => 'content',
            'title' => __('تنظیمات متن دکمه', 'bebanstore'),
            'description' => __('تنظیم متن دکمه افزودن به سبد برای محصولات', 'bebanstore')
        ),
        'button_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن دکمه افزودن به سبد', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای همه محصولات (ساده، متغیر، دانلودی، مجازی، گروهی، خارجی) اعمال می‌شود', 'bebanstore')
                )
            ),
            'default' => 'افزودن به سبد خرید',
            'placeholder' => 'افزودن به سبد خرید'
        ),
        'in_cart_button_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن دکمه زمانی که محصول در سبد خرید است', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای زمانی نمایش داده می‌شود که محصول در سبد خرید کاربر قرار دارد اما هنوز خریداری نشده است. اگر خالی باشد، متن دکمه افزودن به سبد استفاده می‌شود.', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...'
        ),
        'purchased_button_text' => array(
            'tab' => 'content',
            'type' => 'text',
            'label' => __('متن دکمه بعد از خرید محصول', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای کاربرانی که قبلاً این محصول را خریده‌اند نمایش داده می‌شود. اگر خالی باشد، متن دکمه افزودن به سبد استفاده می‌شود.', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...'
        )
    ),
    
    // ========== تنظیمات Pro (فقط در نسخه Pro نمایش داده می‌شود) ==========
    'pro_only_settings' => array(
        
        // ========== سکشن کنترل دکمه ==========
        'button_control_section' => array(
            'type' => 'section_header',
            'tab' => 'pro',
            'title' => __('کنترل نمایش دکمه افزودن به سبد', 'bebanstore'),
            'description' => __('کنترل نمایش و غیرفعال کردن دکمه افزودن به سبد در حالت‌های مختلف', 'bebanstore')
        ),
        
        'disable_button_in_cart' => array(
            'tab' => 'pro',
            'type' => 'checkbox',
            'label' => __('غیرفعال کردن دکمه زمانی که محصول در سبد خرید است', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، دکمه افزودن به سبد زمانی که محصول در سبد خرید است غیرفعال و کمرنگ می‌شود', 'bebanstore')
                )
            ),
            'default' => false,
            'pro' => true
        ),
        
        'disable_button_purchased' => array(
            'tab' => 'pro',
            'type' => 'checkbox',
            'label' => __('غیرفعال کردن دکمه زمانی که محصول خریداری شده است', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('با فعال کردن این گزینه، دکمه افزودن به سبد زمانی که کاربر محصول را خریده است غیرفعال و کمرنگ می‌شود', 'bebanstore')
                )
            ),
            'default' => false,
            'pro' => true
        ),
        
        'disabled_button_opacity' => array(
            'tab' => 'pro',
            'type' => 'number',
            'label' => __('میزان شفافیت دکمه غیرفعال (درصد)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('میزان شفافیت دکمه زمانی که غیرفعال است را تعیین کنید. مقدار از 0 تا 100 (0 = کاملاً شفاف/نامرئی، 100 = کاملاً مات/قابل مشاهده). مقدار پیش‌فرض: 50', 'bebanstore')
                )
            ),
            'default' => 50,
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'placeholder' => '50',
            'pro' => true
        ),
        
        // ========== سکشن محصولات ساده ==========
        'simple_product_section' => array(
            'type' => 'section_header',
            'tab' => 'pro',
            'title' => __('تنظیمات متن دکمه محصولات ساده', 'bebanstore'),
            'description' => __('تنظیم متن دکمه برای محصولات ساده در حالت‌های مختلف', 'bebanstore')
        ),
        
        'simple_product_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات ساده', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات ساده در حالت عادی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'افزودن به سبد خرید',
            'placeholder' => 'افزودن به سبد خرید',
            'pro' => true
        ),
        
        'simple_product_in_cart_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات ساده (در سبد خرید)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات ساده زمانی که در سبد خرید هستند نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...',
            'pro' => true
        ),
        
        'simple_product_purchased_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات ساده (بعد از خرید)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات ساده بعد از خرید توسط کاربر نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...',
            'pro' => true
        ),
        
        // ========== سکشن محصولات متغیر ==========
        'variable_product_section' => array(
            'type' => 'section_header',
            'tab' => 'pro',
            'title' => __('تنظیمات متن دکمه محصولات متغیر', 'bebanstore'),
            'description' => __('تنظیم متن دکمه برای محصولات متغیر در حالت‌های مختلف', 'bebanstore')
        ),
        
        'variable_product_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات متغیر', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات متغیر در حالت عادی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'انتخاب گزینه‌ها',
            'placeholder' => 'انتخاب گزینه‌ها',
            'pro' => true
        ),
        
        'variable_product_in_cart_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات متغیر (در سبد خرید)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات متغیر زمانی که در سبد خرید هستند نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...',
            'pro' => true
        ),
        
        'variable_product_purchased_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات متغیر (بعد از خرید)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات متغیر بعد از خرید توسط کاربر نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...',
            'pro' => true
        ),
        
        // ========== سکشن محصولات دانلودی ==========
        'downloadable_product_section' => array(
            'type' => 'section_header',
            'tab' => 'pro',
            'title' => __('تنظیمات متن دکمه محصولات دانلودی', 'bebanstore'),
            'description' => __('تنظیم متن دکمه برای محصولات دانلودی در حالت‌های مختلف', 'bebanstore')
        ),
        
        'downloadable_product_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات دانلودی', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات دانلودی در حالت عادی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'خرید و دانلود',
            'placeholder' => 'خرید و دانلود',
            'pro' => true
        ),
        
        'downloadable_product_in_cart_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات دانلودی (در سبد خرید)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات دانلودی زمانی که در سبد خرید هستند نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...',
            'pro' => true
        ),
        
        'downloadable_product_purchased_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات دانلودی (بعد از خرید)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات دانلودی بعد از خرید توسط کاربر نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...',
            'pro' => true
        ),
        
        // ========== سکشن محصولات مجازی ==========
        'virtual_product_section' => array(
            'type' => 'section_header',
            'tab' => 'pro',
            'title' => __('تنظیمات متن دکمه محصولات مجازی', 'bebanstore'),
            'description' => __('تنظیم متن دکمه برای محصولات مجازی در حالت‌های مختلف', 'bebanstore')
        ),
        
        'virtual_product_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات مجازی', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات مجازی در حالت عادی نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => 'خرید',
            'placeholder' => 'خرید',
            'pro' => true
        ),
        
        'virtual_product_in_cart_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات مجازی (در سبد خرید)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات مجازی زمانی که در سبد خرید هستند نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...',
            'pro' => true
        ),
        
        'virtual_product_purchased_text' => array(
            'tab' => 'pro',
            'type' => 'text',
            'label' => __('متن دکمه محصولات مجازی (بعد از خرید)', 'bebanstore'),
            'tooltips' => array(
                array(
                    'type' => 'info',
                    'text' => __('این متن برای محصولات مجازی بعد از خرید توسط کاربر نمایش داده می‌شود', 'bebanstore')
                )
            ),
            'default' => '',
            'placeholder' => '...',
            'pro' => true
        )
    )
);

